/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.internal.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.harmony.jndi.internal.parser.LdapParser;

public class LdapNameParser
implements NameParser,
LdapParser {
    private String s = null;

    public LdapNameParser(String s) {
        this.s = s;
    }

    public Name parse(String arg0) throws NamingException {
        return new LdapName(arg0);
    }

    public List getList() throws InvalidNameException {
        ArrayList<Rdn> list = new ArrayList<Rdn>();
        int from = 0;
        char[] c = this.s.toCharArray();
        if (this.s.equals("")) {
            return list;
        }
        if (this.s.startsWith(",") || this.s.startsWith(";")) {
            throw new InvalidNameException("Invalid name: " + this.s);
        }
        int i = 0;
        while (i < c.length) {
            if ((c[i] == ',' || c[i] == ';') && c[i - 1] != '\\') {
                String sub = this.s.substring(from, i);
                if (sub.equals("")) {
                    throw new InvalidNameException("Invalid name: " + this.s);
                }
                list.add(new Rdn(sub));
                from = i + 1;
            }
            ++i;
        }
        list.add(new Rdn(this.s.substring(from, this.s.length())));
        Collections.reverse(list);
        return list;
    }
}

