/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.PercentCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class PercentCodecTest {
    PercentCodecTest() {
    }

    @Test
    void testBasicEncodeDecode() throws Exception {
        PercentCodec percentCodec = new PercentCodec();
        String input = "abcdABCD";
        byte[] encoded = percentCodec.encode("abcdABCD".getBytes(StandardCharsets.UTF_8));
        String encodedS = new String(encoded, StandardCharsets.UTF_8);
        byte[] decoded = percentCodec.decode(encoded);
        String decodedS = new String(decoded, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"abcdABCD", (Object)encodedS, (String)"Basic PercentCodec encoding test");
        Assertions.assertEquals((Object)"abcdABCD", (Object)decodedS, (String)"Basic PercentCodec decoding test");
    }

    @Test
    @Disabled
    void testBasicSpace() throws Exception {
        PercentCodec percentCodec = new PercentCodec();
        String input = " ";
        byte[] encoded = percentCodec.encode(" ".getBytes(StandardCharsets.UTF_8));
        Assertions.assertArrayEquals((byte[])"%20".getBytes(StandardCharsets.UTF_8), (byte[])encoded);
    }

    @Test
    void testConfigurablePercentEncoder() throws Exception {
        String input = "abc123_-.*\u03b1\u03b2";
        PercentCodec percentCodec = new PercentCodec("abcdef".getBytes(StandardCharsets.UTF_8), false);
        byte[] encoded = percentCodec.encode("abc123_-.*\u03b1\u03b2".getBytes(StandardCharsets.UTF_8));
        String encodedS = new String(encoded, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"%61%62%63123_-.*%CE%B1%CE%B2", (Object)encodedS, (String)"Configurable PercentCodec encoding test");
        byte[] decoded = percentCodec.decode(encoded);
        Assertions.assertEquals((Object)new String(decoded, StandardCharsets.UTF_8), (Object)"abc123_-.*\u03b1\u03b2", (String)"Configurable PercentCodec decoding test");
    }

    @Test
    void testDecodeInvalidEncodedResultDecoding() throws Exception {
        String inputS = "\u03b1\u03b2";
        PercentCodec percentCodec = new PercentCodec();
        byte[] encoded = percentCodec.encode("\u03b1\u03b2".getBytes(StandardCharsets.UTF_8));
        try {
            percentCodec.decode(Arrays.copyOf(encoded, encoded.length - 1));
        }
        catch (Exception e) {
            Assertions.assertTrue((DecoderException.class.isInstance(e) && ArrayIndexOutOfBoundsException.class.isInstance(e.getCause()) ? 1 : 0) != 0);
        }
    }

    @Test
    void testDecodeNullObject() throws Exception {
        PercentCodec percentCodec = new PercentCodec();
        Assertions.assertNull((Object)percentCodec.decode(null));
    }

    @Test
    void testDecodeUnsupportedObject() {
        PercentCodec percentCodec = new PercentCodec();
        Assertions.assertThrows(DecoderException.class, () -> percentCodec.decode((Object)"test"));
    }

    @Test
    void testEncodeNullObject() throws Exception {
        PercentCodec percentCodec = new PercentCodec();
        Assertions.assertNull((Object)percentCodec.encode(null));
    }

    @Test
    void testEncodeUnsupportedObject() {
        PercentCodec percentCodec = new PercentCodec();
        Assertions.assertThrows(EncoderException.class, () -> percentCodec.encode((Object)"test"));
    }

    @Test
    void testInvalidByte() throws Exception {
        byte[] invalid = new byte[]{-1, 65};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PercentCodec(invalid, true));
    }

    @Test
    void testPercentEncoderDecoderWithNullOrEmptyInput() throws Exception {
        PercentCodec percentCodec = new PercentCodec(null, true);
        Assertions.assertNull((Object)percentCodec.encode(null), (String)"Null input value encoding test");
        Assertions.assertNull((Object)percentCodec.decode(null), (String)"Null input value decoding test");
        byte[] emptyInput = "".getBytes(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)percentCodec.encode(emptyInput), (Object)emptyInput, (String)"Empty input value encoding test");
        Assertions.assertArrayEquals((byte[])percentCodec.decode(emptyInput), (byte[])emptyInput, (String)"Empty input value decoding test");
    }

    @Test
    void testPercentEncoderDecoderWithPlusForSpace() throws Exception {
        String input = "a b c d";
        PercentCodec percentCodec = new PercentCodec(null, true);
        byte[] encoded = percentCodec.encode("a b c d".getBytes(StandardCharsets.UTF_8));
        String encodedS = new String(encoded, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"a+b+c+d", (Object)encodedS, (String)"PercentCodec plus for space encoding test");
        byte[] decode = percentCodec.decode(encoded);
        Assertions.assertEquals((Object)new String(decode, StandardCharsets.UTF_8), (Object)"a b c d", (String)"PercentCodec plus for space decoding test");
    }

    @Test
    void testSafeCharEncodeDecodeObject() throws Exception {
        PercentCodec percentCodec = new PercentCodec(null, true);
        String input = "abc123_-.*";
        Object encoded = percentCodec.encode((Object)"abc123_-.*".getBytes(StandardCharsets.UTF_8));
        String encodedS = new String((byte[])encoded, StandardCharsets.UTF_8);
        Object decoded = percentCodec.decode(encoded);
        String decodedS = new String((byte[])decoded, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"abc123_-.*", (Object)encodedS, (String)"Basic PercentCodec safe char encoding test");
        Assertions.assertEquals((Object)"abc123_-.*", (Object)decodedS, (String)"Basic PercentCodec safe char decoding test");
    }

    @Test
    void testUnsafeCharEncodeDecode() throws Exception {
        PercentCodec percentCodec = new PercentCodec();
        String input = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6% ";
        byte[] encoded = percentCodec.encode("\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6% ".getBytes(StandardCharsets.UTF_8));
        String encodedS = new String(encoded, StandardCharsets.UTF_8);
        byte[] decoded = percentCodec.decode(encoded);
        String decodedS = new String(decoded, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"%CE%B1%CE%B2%CE%B3%CE%B4%CE%B5%CE%B6%25 ", (Object)encodedS, (String)"Basic PercentCodec unsafe char encoding test");
        Assertions.assertEquals((Object)"\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6% ", (Object)decodedS, (String)"Basic PercentCodec unsafe char decoding test");
    }
}

