/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.apache.commons.beanutils2.BeanMap;
import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.beanutils2.bugs.other.Jira87BeanFactory;
import org.apache.commons.collections4.map.AbstractMapTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;

public class BeanMapTest
extends AbstractMapTest<BeanMap, String, Object> {
    private final Object objectInFullMap = new Object();

    protected Object computeIfAbsent(String key, Function<? super String, ? extends Object> mappingFunction) {
        if (((BeanMap)this.getMap()).getBean() == null) {
            throw new IllegalArgumentException();
        }
        return super.computeIfAbsent((Object)key, mappingFunction);
    }

    public Object[] getNewSampleValues() {
        Object[] values = new Object[]{223, 23341928234L, 23423.34, Float.valueOf(213332.12f), (short)234, (byte)20, Character.valueOf('b'), 232, "SomeNewStringValue", new Object(), null};
        return values;
    }

    public String[] getSampleKeys() {
        String[] keys = new String[]{"someIntValue", "someLongValue", "someDoubleValue", "someFloatValue", "someShortValue", "someByteValue", "someCharValue", "someIntegerValue", "someStringValue", "someObjectValue", "class"};
        return keys;
    }

    public Object[] getSampleValues() {
        Object[] values = new Object[]{1234, 1298341928234L, 123423.34, Float.valueOf(1213332.1f), (short)134, (byte)10, Character.valueOf('a'), 1432, "SomeStringValue", this.objectInFullMap, BeanWithProperties.class};
        return values;
    }

    public String[] ignoredTests() {
        return new String[]{"TestBeanMap.bulkTestMapEntrySet.testCanonicalEmptyCollectionExists", "TestBeanMap.bulkTestMapEntrySet.testCanonicalFullCollectionExists", "TestBeanMap.bulkTestMapKeySet.testCanonicalEmptyCollectionExists", "TestBeanMap.bulkTestMapKeySet.testCanonicalFullCollectionExists", "TestBeanMap.bulkTestMapValues.testCanonicalEmptyCollectionExists", "TestBeanMap.bulkTestMapValues.testCanonicalFullCollectionExists", "TestBeanMap.bulkTestMapEntrySet.testSimpleSerialization", "TestBeanMap.bulkTestMapKeySet.testSimpleSerialization", "TestBeanMap.bulkTestMapEntrySet.testSerializeDeserializeThenCompare", "TestBeanMap.bulkTestMapKeySet.testSerializeDeserializeThenCompare"};
    }

    public boolean isPutAddSupported() {
        return false;
    }

    public boolean isRemoveSupported() {
        return false;
    }

    public BeanMap makeFullMap() {
        BeanWithProperties bean = new BeanWithProperties();
        bean.setSomeIntValue(1234);
        bean.setSomeLongValue(1298341928234L);
        bean.setSomeDoubleValue(123423.34);
        bean.setSomeFloatValue(1213332.1f);
        bean.setSomeShortValue((short)134);
        bean.setSomeByteValue((byte)10);
        bean.setSomeCharValue('a');
        bean.setSomeIntegerValue(1432);
        bean.setSomeStringValue("SomeStringValue");
        bean.setSomeObjectValue(this.objectInFullMap);
        return new BeanMap((Object)bean);
    }

    public BeanMap makeObject() {
        return new BeanMap();
    }

    protected Object putIfAbsent(String key, Object value) {
        if (((BeanMap)this.getMap()).getBean() == null) {
            throw new IllegalArgumentException();
        }
        return super.putIfAbsent((Object)key, value);
    }

    public void testBeanMapClone() {
        BeanMap map = this.makeFullMap();
        try {
            String[] keys;
            BeanMap map2 = (BeanMap)map.clone();
            for (String key : keys = this.getSampleKeys()) {
                Assertions.assertTrue((boolean)map2.containsKey((Object)key), (String)"Cloned BeanMap should contain the same keys");
            }
        }
        catch (CloneNotSupportedException exception) {
            Assertions.fail((String)"BeanMap.clone() should not throw a CloneNotSupportedException when clone should succeed.");
        }
    }

    public void testBeanMapPutAllWriteable() {
        BeanMap map1 = this.makeFullMap();
        BeanMap map2 = this.makeFullMap();
        map2.put("someIntValue", (Object)0);
        map1.putAllWriteable(map2);
        Assertions.assertEquals((Object)map1.get((Object)"someIntValue"), (Object)0);
    }

    public void testExceptionThrowFromClear() {
        try {
            Jira87BeanFactory.PublicMappedInterface bean = Jira87BeanFactory.createMappedPropertyBean();
            BeanMap map = new BeanMap((Object)bean);
            map.clear();
            Assertions.fail((String)"clear() - expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Throwable cause = null;
            try {
                cause = (Throwable)PropertyUtils.getProperty((Object)e, (String)"cause");
            }
            catch (Exception e2) {
                Assertions.fail((String)("Retrieving the cause threw " + e2));
            }
            Assertions.assertNotNull((Object)cause, (String)"Cause null");
            Assertions.assertEquals(IllegalAccessException.class, cause.getClass(), (String)"Cause");
        }
    }

    public void testExceptionThrowFromClone() {
        Throwable cause;
        try {
            Jira87BeanFactory.PublicMappedInterface bean = Jira87BeanFactory.createMappedPropertyBean();
            BeanMap map = new BeanMap((Object)bean);
            map.clone();
            Assertions.fail((String)"Non-public bean clone() - expected CloneNotSupportedException");
        }
        catch (CloneNotSupportedException e) {
            cause = null;
            try {
                cause = (Throwable)PropertyUtils.getProperty((Object)e, (String)"cause");
            }
            catch (Exception e2) {
                Assertions.fail((String)("Non-public bean - retrieving the cause threw " + e2));
            }
            Assertions.assertNotNull((Object)cause, (String)"Non-public bean cause null");
            Assertions.assertEquals(IllegalAccessException.class, cause.getClass(), (String)"Non-public bean cause");
        }
        try {
            BeanMap map = new BeanMap((Object)new BeanThrowingExceptions());
            map.clone();
            Assertions.fail((String)"Setter Exception clone() - expected CloneNotSupportedException");
        }
        catch (CloneNotSupportedException e) {
            cause = null;
            try {
                cause = (Throwable)PropertyUtils.getProperty((Object)e, (String)"cause");
            }
            catch (Exception e2) {
                Assertions.fail((String)("Setter Exception - retrieving the cause threw " + e2));
            }
            Assertions.assertNotNull((Object)cause, (String)"Setter Exception cause null");
            Assertions.assertEquals(IllegalArgumentException.class, cause.getClass(), (String)"Setter Exception cause");
        }
    }

    public void testExceptionThrowFromPut() {
        try {
            BeanMap map = new BeanMap((Object)new BeanThrowingExceptions());
            map.put("valueThrowingException", "value");
            Assertions.fail((String)"Setter exception - expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Throwable cause1 = null;
            Throwable cause2 = null;
            try {
                cause1 = (Throwable)PropertyUtils.getProperty((Object)e, (String)"cause");
                cause2 = (Throwable)PropertyUtils.getProperty((Object)e, (String)"cause.cause");
            }
            catch (Exception e2) {
                Assertions.fail((String)("Setter exception - retrieving the cause threw " + e2));
            }
            Assertions.assertNotNull((Object)cause1, (String)"Setter exception cause 1 null");
            Assertions.assertEquals(InvocationTargetException.class, cause1.getClass(), (String)"Setter exception cause 1");
            Assertions.assertNotNull((Object)cause2, (String)"Setter exception cause 2 null");
            Assertions.assertEquals(TestException.class, cause2.getClass(), (String)"Setter exception cause 2");
        }
    }

    public void testGetTypeTransformerMethod() {
        BeanMap beanMap = new BeanMap();
        Assertions.assertEquals((Object)Boolean.TRUE, beanMap.getTypeTransformer(Boolean.TYPE).apply("true"), (String)"Boolean.TYPE");
        Assertions.assertEquals((Character)Character.valueOf('B'), (Character)((Character)beanMap.getTypeTransformer(Character.TYPE).apply("BCD")), (String)"Character.TYPE");
        Assertions.assertEquals((Byte)1, (Byte)((Byte)beanMap.getTypeTransformer(Byte.TYPE).apply("1")), (String)"Byte.TYPE");
        Assertions.assertEquals((Short)2, (Short)((Short)beanMap.getTypeTransformer(Short.TYPE).apply("2")), (String)"Short.TYPE");
        Assertions.assertEquals((Integer)3, (Integer)((Integer)beanMap.getTypeTransformer(Integer.TYPE).apply("3")), (String)"Integer.TYPE");
        Assertions.assertEquals((Long)4L, (Long)((Long)beanMap.getTypeTransformer(Long.TYPE).apply("4")), (String)"Long.TYPE");
        Assertions.assertEquals((Float)Float.valueOf("5"), (Float)((Float)beanMap.getTypeTransformer(Float.TYPE).apply("5")), (String)"Float.TYPE");
        Assertions.assertEquals((Double)Double.valueOf("6"), (Double)((Double)beanMap.getTypeTransformer(Double.TYPE).apply("6")), (String)"Double.TYPE");
    }

    public void testMapClear() {
    }

    public void testMapPut() {
    }

    public void testMethodAccessor() throws Exception {
        BeanMap map = this.makeFullMap();
        Method method = BeanWithProperties.class.getDeclaredMethod("getSomeIntegerValue", new Class[0]);
        Assertions.assertEquals((Object)method, (Object)map.getReadMethod("someIntegerValue"));
    }

    public void testMethodMutator() throws Exception {
        BeanMap map = this.makeFullMap();
        Method method = BeanWithProperties.class.getDeclaredMethod("setSomeIntegerValue", Integer.class);
        Assertions.assertEquals((Object)method, (Object)map.getWriteMethod("someIntegerValue"));
    }

    public void testReplaceAll() {
        Assumptions.assumeFalse((boolean)((BeanMap)this.getMap()).keySet().stream().anyMatch(k -> ((BeanMap)this.getMap()).getWriteMethod(k) == null));
        super.testReplaceAll();
    }

    public void verifyValues() {
        this.values = ((BeanMap)this.map).values();
        super.verifyValues();
    }

    public static class BeanWithProperties {
        private int someInt;
        private long someLong;
        private double someDouble;
        private float someFloat;
        private short someShort;
        private byte someByte;
        private char someChar;
        private Integer someInteger;
        private String someString;
        private Object someObject;

        public byte getSomeByteValue() {
            return this.someByte;
        }

        public char getSomeCharValue() {
            return this.someChar;
        }

        public double getSomeDoubleValue() {
            return this.someDouble;
        }

        public float getSomeFloatValue() {
            return this.someFloat;
        }

        public Integer getSomeIntegerValue() {
            return this.someInteger;
        }

        public int getSomeIntValue() {
            return this.someInt;
        }

        public long getSomeLongValue() {
            return this.someLong;
        }

        public Object getSomeObjectValue() {
            return this.someObject;
        }

        public short getSomeShortValue() {
            return this.someShort;
        }

        public String getSomeStringValue() {
            return this.someString;
        }

        public void setSomeByteValue(byte value) {
            this.someByte = value;
        }

        public void setSomeCharValue(char value) {
            this.someChar = value;
        }

        public void setSomeDoubleValue(double value) {
            this.someDouble = value;
        }

        public void setSomeFloatValue(float value) {
            this.someFloat = value;
        }

        public void setSomeIntegerValue(Integer value) {
            this.someInteger = value;
        }

        public void setSomeIntValue(int value) {
            this.someInt = value;
        }

        public void setSomeLongValue(long value) {
            this.someLong = value;
        }

        public void setSomeObjectValue(Object value) {
            this.someObject = value;
        }

        public void setSomeShortValue(short value) {
            this.someShort = value;
        }

        public void setSomeStringValue(String value) {
            this.someString = value;
        }
    }

    public static class BeanThrowingExceptions
    extends BeanWithProperties {
        public String getValueThrowingException() {
            throw new TestException();
        }

        public void setValueThrowingException(String value) {
            throw new TestException();
        }
    }

    public static class TestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

