/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale.converters;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils2.locale.converters.DecimalLocaleConverter;

public class BigIntegerLocaleConverter
extends DecimalLocaleConverter<BigInteger> {
    public static Builder builder() {
        return new Builder();
    }

    private BigIntegerLocaleConverter(BigInteger defaultValue, Locale locale, String pattern, boolean useDefault, boolean locPattern) {
        super(defaultValue, locale, pattern, useDefault, locPattern);
    }

    @Override
    protected BigInteger parse(Object value, String pattern) throws ParseException {
        Object result = super.parse(value, pattern);
        if (result == null || result instanceof BigInteger) {
            return (BigInteger)result;
        }
        return BigInteger.valueOf(((Number)result).longValue());
    }

    public static class Builder
    extends DecimalLocaleConverter.Builder<Builder, BigInteger> {
        @Override
        public BigIntegerLocaleConverter get() {
            return new BigIntegerLocaleConverter((BigInteger)this.defaultValue, this.locale, this.pattern, this.useDefault || this.defaultValue != null, this.localizedPattern);
        }
    }
}

