/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.bcel.generic;

/**
 * Denote entity that has both name and type. This is true for local variables, methods and fields.
 */
public interface NamedAndTyped {

    /**
     * Gets the name.
     *
     * @return the name.
     */
    String getName();

    /**
     * Gets the type.
     *
     * @return the type.
     */
    Type getType();

    /**
     * Sets the name.
     *
     * @param name the name.
     */
    void setName(String name);

    /**
     * Sets the type.
     *
     * @param type the type.
     */
    void setType(Type type);
}
