/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import org.apache.cayenne.map.CallbackDescriptor;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.util.XMLEncoder;

public class CallbackMap
implements Serializable {
    protected CallbackDescriptor[] callbacks = new CallbackDescriptor[LifecycleEvent.values().length];

    public CallbackMap() {
        LifecycleEvent[] events = LifecycleEvent.values();
        this.callbacks = new CallbackDescriptor[events.length];
        for (int i = 0; i < events.length; ++i) {
            this.callbacks[i] = new CallbackDescriptor(events[i]);
        }
    }

    public CallbackDescriptor[] getCallbacks() {
        return this.callbacks;
    }

    public CallbackDescriptor getCallbackDescriptor(LifecycleEvent callbackType) {
        return this.callbacks[callbackType.ordinal()];
    }

    public CallbackDescriptor getPostLoad() {
        return this.callbacks[LifecycleEvent.POST_LOAD.ordinal()];
    }

    public CallbackDescriptor getPostPersist() {
        return this.callbacks[LifecycleEvent.POST_PERSIST.ordinal()];
    }

    public CallbackDescriptor getPostRemove() {
        return this.callbacks[LifecycleEvent.POST_REMOVE.ordinal()];
    }

    public CallbackDescriptor getPostUpdate() {
        return this.callbacks[LifecycleEvent.POST_UPDATE.ordinal()];
    }

    public CallbackDescriptor getPostAdd() {
        return this.callbacks[LifecycleEvent.POST_ADD.ordinal()];
    }

    public CallbackDescriptor getPrePersist() {
        return this.callbacks[LifecycleEvent.PRE_PERSIST.ordinal()];
    }

    public CallbackDescriptor getPreRemove() {
        return this.callbacks[LifecycleEvent.PRE_REMOVE.ordinal()];
    }

    public CallbackDescriptor getPreUpdate() {
        return this.callbacks[LifecycleEvent.PRE_UPDATE.ordinal()];
    }

    public void encodeCallbacksAsXML(XMLEncoder encoder) {
        CallbackMap.printMethods(this.getPostAdd(), "post-add", encoder);
        CallbackMap.printMethods(this.getPrePersist(), "pre-persist", encoder);
        CallbackMap.printMethods(this.getPostPersist(), "post-persist", encoder);
        CallbackMap.printMethods(this.getPreUpdate(), "pre-update", encoder);
        CallbackMap.printMethods(this.getPostUpdate(), "post-update", encoder);
        CallbackMap.printMethods(this.getPreRemove(), "pre-remove", encoder);
        CallbackMap.printMethods(this.getPostRemove(), "post-remove", encoder);
        CallbackMap.printMethods(this.getPostLoad(), "post-load", encoder);
    }

    private static void printMethods(CallbackDescriptor descriptor, String stringCallbackName, XMLEncoder encoder) {
        for (String methodName : descriptor.getCallbackMethods()) {
            encoder.print("<");
            encoder.print(stringCallbackName);
            encoder.print(" method-name=\"");
            encoder.print(methodName);
            encoder.println("\"/>");
        }
    }
}

