/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorControllerPanel;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.CodeValidationUtil;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.PreferenceDetail;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.SimpleValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.apache.commons.collections.Predicate;

public abstract class GeneratorController
extends CayenneController {
    protected DataMapDefaults preferences;
    protected String mode = ArtifactsGenerationMode.ENTITY.getLabel();

    public GeneratorController(CodeGeneratorControllerBase parent) {
        super(parent);
        this.createDefaults();
        this.createView();
        this.initBindings(new BindingBuilder(this.getApplication().getBindingFactory(), this));
    }

    public String getOutputPath() {
        return this.preferences.getOutputPath();
    }

    public void setOutputPath(String path) {
        this.preferences.setOutputPath(path);
    }

    protected void initBindings(BindingBuilder bindingBuilder) {
        this.initOutputFolder();
        JTextField outputFolder = ((GeneratorControllerPanel)this.getView()).getOutputFolder();
        JButton outputSelect = ((GeneratorControllerPanel)this.getView()).getSelectOutputFolder();
        outputFolder.setText(this.getOutputPath());
        bindingBuilder.bindToAction(outputSelect, "selectOutputFolderAction()");
        bindingBuilder.bindToTextField(outputFolder, "outputPath");
    }

    protected CodeGeneratorControllerBase getParentController() {
        return (CodeGeneratorControllerBase)this.getParent();
    }

    protected abstract GeneratorControllerPanel createView();

    protected abstract DataMapDefaults createDefaults();

    protected abstract ClassGenerationAction newGenerator();

    public ClassGenerationAction createGenerator() {
        File outputDir = this.getOutputDir();
        if (outputDir == null) {
            JOptionPane.showMessageDialog(this.getView(), "Select directory for source files.");
            return null;
        }
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            JOptionPane.showMessageDialog(this.getView(), "Can't create directory " + outputDir + ". Select a different one.");
            return null;
        }
        if (!outputDir.isDirectory()) {
            JOptionPane.showMessageDialog(this.getView(), outputDir + " is not a valid directory.");
            return null;
        }
        ArrayList<ObjEntity> entities = new ArrayList<ObjEntity>(this.getParentController().getSelectedEntities());
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            if (!((ObjEntity)it.next()).isGeneric()) continue;
            it.remove();
        }
        ClassGenerationAction generator = this.newGenerator();
        generator.setArtifactsGenerationMode(this.mode);
        generator.setDataMap(this.getParentController().getDataMap());
        generator.addEntities(entities);
        generator.addEmbeddables(this.getParentController().getSelectedEmbeddables());
        generator.addQueries(this.getParentController().getDataMap().getQueries());
        Domain generatorPrefs = Application.getInstance().getPreferenceDomain().getSubdomain(ClassGenerationAction.class);
        PreferenceDetail detail = generatorPrefs.getDetail("encoding", false);
        if (detail != null) {
            generator.setEncoding(detail.getProperty("encoding"));
        }
        generator.setDestDir(outputDir);
        generator.setMakePairs(true);
        String superPackage = ((GeneratorControllerPanel)this.getView()).getSuperclassPackage().getText();
        if (!Util.isEmptyString((String)superPackage)) {
            generator.setSuperPkg(superPackage);
        }
        return generator;
    }

    public void validateEmbeddable(ValidationResult validationBuffer, Embeddable embeddable) {
        ValidationFailure embeddableFailure = this.validateEmbeddable(embeddable);
        if (embeddableFailure != null) {
            validationBuffer.addFailure(embeddableFailure);
            return;
        }
        for (EmbeddableAttribute attribute : embeddable.getAttributes()) {
            ValidationFailure failure = this.validateEmbeddableAttribute(attribute);
            if (failure == null) continue;
            validationBuffer.addFailure(failure);
            return;
        }
    }

    private ValidationFailure validateEmbeddableAttribute(EmbeddableAttribute attribute) {
        String name = attribute.getEmbeddable().getClassName();
        ValidationFailure emptyName = BeanValidationFailure.validateNotEmpty((Object)name, (String)"attribute.name", (String)attribute.getName());
        if (emptyName != null) {
            return emptyName;
        }
        ValidationFailure badName = CodeValidationUtil.validateJavaIdentifier(name, "attribute.name", attribute.getName());
        if (badName != null) {
            return badName;
        }
        ValidationFailure emptyType = BeanValidationFailure.validateNotEmpty((Object)name, (String)"attribute.type", (String)attribute.getType());
        if (emptyType != null) {
            return emptyType;
        }
        ValidationFailure badType = BeanValidationFailure.validateJavaClassName((Object)name, (String)"attribute.type", (String)attribute.getType());
        if (badType != null) {
            return badType;
        }
        return null;
    }

    protected ValidationFailure validateEmbeddable(Embeddable embeddable) {
        String name = embeddable.getClassName();
        ValidationFailure emptyClass = BeanValidationFailure.validateNotEmpty((Object)name, (String)"className", (String)embeddable.getClassName());
        if (emptyClass != null) {
            return emptyClass;
        }
        ValidationFailure badClass = BeanValidationFailure.validateJavaClassName((Object)name, (String)"className", (String)embeddable.getClassName());
        if (badClass != null) {
            return badClass;
        }
        return null;
    }

    public void validateEntity(ValidationResult validationBuffer, ObjEntity entity, boolean clientValidation) {
        ValidationFailure failure;
        ValidationFailure entityFailure = this.validateEntity(clientValidation ? entity.getClientEntity() : entity);
        if (entityFailure != null) {
            validationBuffer.addFailure(entityFailure);
            return;
        }
        for (ObjAttribute attribute : entity.getAttributes()) {
            if (attribute instanceof EmbeddedAttribute) {
                EmbeddedAttribute embeddedAttribute = (EmbeddedAttribute)attribute;
                for (ObjAttribute subAttribute : embeddedAttribute.getAttributes()) {
                    ValidationFailure failure2 = this.validateEmbeddedAttribute(subAttribute);
                    if (failure2 == null) continue;
                    validationBuffer.addFailure(failure2);
                    return;
                }
                continue;
            }
            failure = this.validateAttribute(attribute);
            if (failure == null) continue;
            validationBuffer.addFailure(failure);
            return;
        }
        for (ObjRelationship rel : entity.getRelationships()) {
            failure = this.validateRelationship(rel, clientValidation);
            if (failure == null) continue;
            validationBuffer.addFailure(failure);
            return;
        }
    }

    protected ValidationFailure validateEntity(ObjEntity entity) {
        ValidationFailure badSuperClass;
        String name = entity.getName();
        if (entity.isGeneric()) {
            return new SimpleValidationFailure((Object)name, (Object)"Generic class");
        }
        ValidationFailure emptyClass = BeanValidationFailure.validateNotEmpty((Object)name, (String)"className", (String)entity.getClassName());
        if (emptyClass != null) {
            return emptyClass;
        }
        ValidationFailure badClass = BeanValidationFailure.validateJavaClassName((Object)name, (String)"className", (String)entity.getClassName());
        if (badClass != null) {
            return badClass;
        }
        if (entity.getSuperClassName() != null && (badSuperClass = BeanValidationFailure.validateJavaClassName((Object)name, (String)"superClassName", (String)entity.getSuperClassName())) != null) {
            return badSuperClass;
        }
        return null;
    }

    protected ValidationFailure validateAttribute(ObjAttribute attribute) {
        String name = attribute.getEntity().getName();
        ValidationFailure emptyName = BeanValidationFailure.validateNotEmpty((Object)name, (String)"attribute.name", (String)attribute.getName());
        if (emptyName != null) {
            return emptyName;
        }
        ValidationFailure badName = CodeValidationUtil.validateJavaIdentifier(name, "attribute.name", attribute.getName());
        if (badName != null) {
            return badName;
        }
        ValidationFailure emptyType = BeanValidationFailure.validateNotEmpty((Object)name, (String)"attribute.type", (String)attribute.getType());
        if (emptyType != null) {
            return emptyType;
        }
        ValidationFailure badType = BeanValidationFailure.validateJavaClassName((Object)name, (String)"attribute.type", (String)attribute.getType());
        if (badType != null) {
            return badType;
        }
        return null;
    }

    protected ValidationFailure validateEmbeddedAttribute(ObjAttribute attribute) {
        String name = attribute.getEntity().getName();
        String[] attributes = attribute.getName().split("\\.");
        String nameEmbeddedAttribute = attributes[0];
        int beginIndex = attributes[0].length();
        String attr = attribute.getName().substring(beginIndex + 1);
        ValidationFailure emptyEmbeddedName = BeanValidationFailure.validateNotEmpty((Object)name, (String)"attribute.name", (String)nameEmbeddedAttribute);
        if (emptyEmbeddedName != null) {
            return emptyEmbeddedName;
        }
        ValidationFailure badEmbeddedName = CodeValidationUtil.validateJavaIdentifier(name, "attribute.name", nameEmbeddedAttribute);
        if (badEmbeddedName != null) {
            return badEmbeddedName;
        }
        ValidationFailure emptyName = BeanValidationFailure.validateNotEmpty((Object)name, (String)"attribute.name", (String)attr);
        if (emptyName != null) {
            return emptyName;
        }
        ValidationFailure badName = CodeValidationUtil.validateJavaIdentifier(name, "attribute.name", attr);
        if (badName != null) {
            return badName;
        }
        ValidationFailure emptyType = BeanValidationFailure.validateNotEmpty((Object)name, (String)"attribute.type", (String)attribute.getType());
        if (emptyType != null) {
            return emptyType;
        }
        ValidationFailure badType = BeanValidationFailure.validateJavaClassName((Object)name, (String)"attribute.type", (String)attribute.getType());
        if (badType != null) {
            return badType;
        }
        return null;
    }

    protected ValidationFailure validateRelationship(ObjRelationship relationship, boolean clientValidation) {
        String name = relationship.getSourceEntity().getName();
        ValidationFailure emptyName = BeanValidationFailure.validateNotEmpty((Object)name, (String)"relationship.name", (String)relationship.getName());
        if (emptyName != null) {
            return emptyName;
        }
        ValidationFailure badName = CodeValidationUtil.validateJavaIdentifier(name, "relationship.name", relationship.getName());
        if (badName != null) {
            return badName;
        }
        if (!relationship.isToMany()) {
            ObjEntity targetEntity = (ObjEntity)relationship.getTargetEntity();
            if (clientValidation && targetEntity != null) {
                targetEntity = targetEntity.getClientEntity();
            }
            if (targetEntity == null) {
                return new BeanValidationFailure((Object)name, "relationship.targetEntity", (Object)"No target entity");
            }
            if (!targetEntity.isGeneric()) {
                ValidationFailure emptyClass = BeanValidationFailure.validateNotEmpty((Object)name, (String)"relationship.targetEntity.className", (String)targetEntity.getClassName());
                if (emptyClass != null) {
                    return emptyClass;
                }
                ValidationFailure badClass = BeanValidationFailure.validateJavaClassName((Object)name, (String)"relationship.targetEntity.className", (String)targetEntity.getClassName());
                if (badClass != null) {
                    return badClass;
                }
            }
        }
        return null;
    }

    public Predicate getDefaultClassFilter() {
        final ObjEntity selectedEntity = Application.getInstance().getFrameController().getProjectController().getCurrentObjEntity();
        final Embeddable selectedEmbeddable = Application.getInstance().getFrameController().getProjectController().getCurrentEmbeddable();
        if (selectedEntity != null) {
            final boolean hasProblem = this.getParentController().getProblem(selectedEntity.getName()) != null;
            return new Predicate(){

                public boolean evaluate(Object object) {
                    return !hasProblem && object == selectedEntity;
                }
            };
        }
        if (selectedEmbeddable != null) {
            final boolean hasProblem = this.getParentController().getProblem(selectedEmbeddable.getClassName()) != null;
            return new Predicate(){

                public boolean evaluate(Object object) {
                    return !hasProblem && object == selectedEmbeddable;
                }
            };
        }
        return new Predicate(){

            public boolean evaluate(Object object) {
                if (object instanceof ObjEntity) {
                    return GeneratorController.this.getParentController().getProblem(((ObjEntity)object).getName()) == null;
                }
                if (object instanceof Embeddable) {
                    return GeneratorController.this.getParentController().getProblem(((Embeddable)object).getClassName()) == null;
                }
                return false;
            }
        };
    }

    public File getOutputDir() {
        String dir = ((GeneratorControllerPanel)this.getView()).getOutputFolder().getText();
        return dir != null ? new File(dir) : new File(System.getProperty("user.dir"));
    }

    public DataMapDefaults getPreferences() {
        return this.preferences;
    }

    public void selectOutputFolderAction() {
        JTextField outputFolder = ((GeneratorControllerPanel)this.getView()).getOutputFolder();
        String currentDir = outputFolder.getText();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogType(0);
        if (!Util.isEmptyString((String)currentDir)) {
            chooser.setCurrentDirectory(new File(currentDir));
        } else {
            FSPath lastDir = Application.getInstance().getFrameController().getLastDirectory();
            lastDir.updateChooser(chooser);
        }
        int result = chooser.showOpenDialog(this.getView());
        if (result == 0) {
            File selected = chooser.getSelectedFile();
            String path = selected.getAbsolutePath();
            outputFolder.setText(path);
            this.setOutputPath(path);
        }
    }

    private void initOutputFolder() {
        String path = null;
        if (this.preferences.getOutputPath() == null) {
            if (System.getProperty("cayenne.cgen.destdir") != null) {
                this.setOutputPath(System.getProperty("cayenne.cgen.destdir"));
            } else {
                FSPath lastPath = Application.getInstance().getFrameController().getLastDirectory();
                path = this.checkDefaultMavenResourceDir(lastPath, "test");
                if (path != null || (path = this.checkDefaultMavenResourceDir(lastPath, "main")) != null) {
                    this.setOutputPath(path);
                } else {
                    File lastDir = lastPath != null ? lastPath.getExistingDirectory(false) : null;
                    this.setOutputPath(lastDir != null ? lastDir.getAbsolutePath() : null);
                }
            }
        }
    }

    private String checkDefaultMavenResourceDir(FSPath lastPath, String dirType) {
        String path = lastPath.getPath();
        String resourcePath = GeneratorController.buildFilePath("src", dirType, "resources");
        int idx = path.indexOf(resourcePath);
        if (idx < 0) {
            return null;
        }
        return path.substring(0, idx) + GeneratorController.buildFilePath("src", dirType, "java") + path.substring(idx + resourcePath.length());
    }

    private static final String buildFilePath(String ... pathElements) {
        if (pathElements.length == 0) {
            return "";
        }
        StringBuilder path = new StringBuilder(pathElements[0]);
        for (int i = 1; i < pathElements.length; ++i) {
            path.append(File.separator).append(pathElements[i]);
        }
        return path.toString();
    }
}

