/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateRelationshipUndoableEdit
extends CayenneUndoableEdit {
    private ObjEntity objEnt;
    private ObjRelationship[] objectRel;
    private DbEntity dbEnt;
    private DbRelationship[] dbRel;

    public CreateRelationshipUndoableEdit(ObjEntity objEnt, ObjRelationship[] objectRel) {
        this.objEnt = objEnt;
        this.objectRel = objectRel;
    }

    public CreateRelationshipUndoableEdit(DbEntity dbEnt, DbRelationship[] dbRel) {
        this.dbEnt = dbEnt;
        this.dbRel = dbRel;
    }

    public String getPresentationName() {
        return "Create Relationship";
    }

    public void redo() throws CannotRedoException {
        CreateRelationshipAction action = (CreateRelationshipAction)this.actionManager.getAction(CreateRelationshipAction.getActionName());
        if (this.objEnt != null) {
            for (Relationship relationship : this.objectRel) {
                action.createObjRelationship(this.objEnt, (ObjRelationship)relationship);
            }
        }
        if (this.dbEnt != null) {
            for (Relationship relationship : this.dbRel) {
                action.createDbRelationship(this.dbEnt, (DbRelationship)relationship);
            }
        }
    }

    public void undo() throws CannotUndoException {
        RemoveRelationshipAction action = (RemoveRelationshipAction)this.actionManager.getAction(RemoveRelationshipAction.getActionName());
        if (this.objEnt != null) {
            action.removeObjRelationships(this.objEnt, this.objectRel);
            this.controller.fireObjEntityDisplayEvent(new EntityDisplayEvent((Object)this, this.objEnt, this.objEnt.getDataMap(), this.controller.getCurrentDataDomain()));
        }
        if (this.dbEnt != null) {
            action.removeDbRelationships(this.dbEnt, this.dbRel);
            this.controller.fireDbEntityDisplayEvent(new EntityDisplayEvent((Object)this, this.dbEnt, this.dbEnt.getDataMap(), this.controller.getCurrentDataDomain()));
        }
    }
}

