/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import org.apache.cayenne.modeler.dialog.pref.EncodingSelectorView;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.util.Util;

public class EncodingSelector
extends CayenneController {
    public static final String ENCODING_PROPERTY_BINDING = "encoding";
    protected PropertyChangeListener encodingChangeListener;
    protected ObjectBinding defaultEncodingBinding;
    protected ObjectBinding otherEncodingBinding;
    protected ObjectBinding selectedEncodingBinding;
    protected EncodingSelectorView view;
    protected String systemEncoding;
    protected String encoding;
    protected boolean defaultEncoding;

    public EncodingSelector(CayenneController parent) {
        this(parent, new EncodingSelectorView());
    }

    public EncodingSelector(CayenneController parent, EncodingSelectorView view) {
        super(parent);
        this.view = view;
        this.initBindings();
    }

    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        this.systemEncoding = this.detectPlatformEncoding();
        Vector allEncodings = this.supportedEncodings(this.systemEncoding);
        this.view.getEncodingChoices().setModel(new DefaultComboBoxModel(allEncodings));
        this.view.getDefaultEncodingLabel().setText("Default (" + this.systemEncoding + ")");
        this.view.getDefaultEncoding().setSelected(true);
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        this.defaultEncodingBinding = builder.bindToStateChange(this.view.getDefaultEncoding(), "defaultEncoding");
        this.otherEncodingBinding = builder.bindToStateChange(this.view.getOtherEncoding(), "otherEncoding");
        this.selectedEncodingBinding = builder.bindToComboSelection(this.view.getEncodingChoices(), ENCODING_PROPERTY_BINDING);
    }

    protected String detectPlatformEncoding() {
        return new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
    }

    protected Vector supportedEncodings(String platformEncoding) {
        String[] defaultCharsets = new String[]{"US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16"};
        Vector<String> charsets = new Vector<String>(Arrays.asList(defaultCharsets));
        if (!charsets.contains(platformEncoding)) {
            charsets.add(platformEncoding);
        }
        Collections.sort(charsets);
        return charsets;
    }

    public void bindingUpdated(String expression, Object newValue) {
        if (ENCODING_PROPERTY_BINDING.equals(expression)) {
            this.encoding = newValue != null ? newValue.toString() : null;
            this.defaultEncoding = this.encoding == null || this.encoding.equals(this.systemEncoding);
            this.selectedEncodingBinding.updateView();
            if (this.defaultEncoding) {
                this.defaultEncodingBinding.updateView();
                this.view.getEncodingChoices().setEnabled(false);
                this.view.getDefaultEncodingLabel().setEnabled(true);
            } else {
                this.otherEncodingBinding.updateView();
                this.view.getEncodingChoices().setEnabled(true);
                this.view.getDefaultEncodingLabel().setEnabled(false);
            }
        }
    }

    public void setEncoding(String encoding) {
        if (!Util.nullSafeEquals(this.encoding, encoding)) {
            String old = this.encoding;
            this.encoding = encoding;
            this.firePropertyChange(ENCODING_PROPERTY_BINDING, old, encoding);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(boolean b) {
        if (b != this.defaultEncoding) {
            this.defaultEncoding = b;
            if (b) {
                this.setEncoding(this.systemEncoding);
                this.view.getEncodingChoices().setEnabled(false);
                this.view.getDefaultEncodingLabel().setEnabled(true);
            } else {
                this.view.getEncodingChoices().setEnabled(true);
                this.view.getDefaultEncodingLabel().setEnabled(false);
            }
        }
    }

    public boolean isOtherEncoding() {
        return !this.isDefaultEncoding();
    }

    public void setOtherEncoding(boolean b) {
        this.setDefaultEncoding(!b);
    }
}

