/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.DropRelationshipToDb;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.SetAllowNullToDb;
import org.apache.cayenne.merge.SetColumnTypeToDb;
import org.apache.cayenne.merge.SetNotNullToDb;
import org.apache.cayenne.merge.SetPrimaryKeyToDb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLMergerFactory
extends MergerFactory {
    @Override
    public MergerToken createSetNotNullToDb(DbEntity entity, final DbAttribute column) {
        return new SetNotNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuffer sqlBuffer = new StringBuffer();
                QuotingStrategy context = adapter.getQuotingStrategy(this.getEntity().getDataMap().isQuotingSQLIdentifiers());
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(context.quoteFullyQualifiedName(this.getEntity()));
                sqlBuffer.append(" CHANGE ");
                sqlBuffer.append(context.quoteString(this.getColumn().getName()));
                sqlBuffer.append(" ");
                adapter.createTableAppendColumn(sqlBuffer, column);
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }

    @Override
    public MergerToken createSetAllowNullToDb(DbEntity entity, final DbAttribute column) {
        return new SetAllowNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuffer sqlBuffer = new StringBuffer();
                QuotingStrategy context = adapter.getQuotingStrategy(this.getEntity().getDataMap().isQuotingSQLIdentifiers());
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(context.quoteFullyQualifiedName(this.getEntity()));
                sqlBuffer.append(" CHANGE ");
                sqlBuffer.append(context.quoteString(this.getColumn().getName()));
                sqlBuffer.append(" ");
                adapter.createTableAppendColumn(sqlBuffer, column);
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }

    @Override
    public MergerToken createSetColumnTypeToDb(final DbEntity entity, DbAttribute columnOriginal, final DbAttribute columnNew) {
        return new SetColumnTypeToDb(entity, columnOriginal, columnNew){

            protected void appendPrefix(StringBuffer sqlBuffer, QuotingStrategy context) {
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(context.quoteFullyQualifiedName(entity));
                sqlBuffer.append(" MODIFY ");
                sqlBuffer.append(context.quoteString(columnNew.getName()));
                sqlBuffer.append(" ");
            }
        };
    }

    @Override
    public MergerToken createDropRelationshipToDb(final DbEntity entity, DbRelationship rel) {
        return new DropRelationshipToDb(entity, rel){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                String fkName = this.getFkName();
                if (fkName == null) {
                    return Collections.emptyList();
                }
                QuotingStrategy context = adapter.getQuotingStrategy(this.getEntity().getDataMap().isQuotingSQLIdentifiers());
                StringBuilder buf = new StringBuilder();
                buf.append("ALTER TABLE ");
                buf.append(context.quoteFullyQualifiedName(entity));
                buf.append(" DROP FOREIGN KEY ");
                buf.append(fkName);
                return Collections.singletonList(buf.toString());
            }
        };
    }

    @Override
    public MergerToken createSetPrimaryKeyToDb(DbEntity entity, Collection<DbAttribute> primaryKeyOriginal, Collection<DbAttribute> primaryKeyNew, String detectedPrimaryKeyName) {
        return new SetPrimaryKeyToDb(entity, primaryKeyOriginal, primaryKeyNew, detectedPrimaryKeyName){

            @Override
            protected void appendDropOriginalPrimaryKeySQL(DbAdapter adapter, List<String> sqls) {
                sqls.add("ALTER TABLE " + this.getQuotingStrategy(adapter).quoteFullyQualifiedName(this.getEntity()) + " DROP PRIMARY KEY");
            }
        };
    }
}

