/*
 * Decompiled with CFR 0.152.
 */
package foundrylogic.vpp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;

public class VPPProperty {
    private String key;
    private String value;
    private Path file;
    private String encoding;

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public Path getFile() {
        return this.file;
    }

    public void setFile(Path path) {
        this.file = path;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    protected ExtendedProperties load(Project project) {
        ExtendedProperties extendedProperties = new ExtendedProperties();
        String[] stringArray = this.file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            InputStream inputStream = null;
            String string = stringArray[i];
            try {
                File file = project.resolveFile(string);
                inputStream = new FileInputStream(file);
            }
            catch (Exception exception) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                inputStream = classLoader.getResourceAsStream(string);
            }
            if (inputStream == null) {
                throw new BuildException("properties file '" + string + "' could not be found in either the file system or the classpath.");
            }
            try {
                if (this.encoding == null) {
                    extendedProperties.load(inputStream);
                    continue;
                }
                extendedProperties.load(inputStream, this.encoding);
                continue;
            }
            catch (IOException iOException) {
                throw new BuildException("error reading properties file '" + string + "'");
            }
        }
        return extendedProperties;
    }
}

