/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import java.awt.event.ActionEvent;
import java.beans.Beans;
import javax.swing.Action;
import javax.swing.JPasswordField;
import javax.swing.JToolTip;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.Control;
import org.scopemvc.core.Controller;
import org.scopemvc.core.PropertyView;
import org.scopemvc.core.Selector;
import org.scopemvc.util.convertor.StringConvertor;
import org.scopemvc.util.convertor.StringConvertors;
import org.scopemvc.view.swing.ControlIssuer;
import org.scopemvc.view.swing.Refreshable;
import org.scopemvc.view.swing.SwingBoundModel;
import org.scopemvc.view.swing.SwingUtil;
import org.scopemvc.view.swing.ValidationHelper;
import org.scopemvc.view.util.ModelBindable;

public class SPasswordField
extends JPasswordField
implements PropertyView,
ModelBindable,
Refreshable {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$SPasswordField == null ? (class$org$scopemvc$view$swing$SPasswordField = SPasswordField.class$("org.scopemvc.view.swing.SPasswordField")) : class$org$scopemvc$view$swing$SPasswordField);
    private static final Action[] DEFAULT_ACTIONS = new Action[]{new NotifyAction()};
    private SwingBoundModel boundModel = new SwingBoundModel(this);
    private ValidationHelper validationHelper = new ValidationHelper(this);
    private String controlID;
    private boolean valueIsNull = false;
    private boolean disableOnNull = false;
    private StringConvertor stringConvertor;
    private StringConvertor forcedStringConvertor;
    private boolean readOnly = false;
    private boolean userEnabled = true;
    private ControlIssuer controlIssuer = new ControlIssuer("SPasswordField"){

        protected Object getComponentValue() {
            try {
                Object object = SPasswordField.this.getViewValue();
                if (object != null) {
                    return new Integer(object.hashCode());
                }
                return new Integer(0);
            }
            catch (Exception exception) {
                return null;
            }
        }

        protected void doViewChanged() {
            SPasswordField.this.viewChanged();
        }

        protected void doIssueControl() {
            if (SPasswordField.this.controlID != null) {
                Control control = new Control(SPasswordField.this.controlID);
                SPasswordField.this.issueControl(control);
            }
        }
    };
    static /* synthetic */ Class class$org$scopemvc$view$swing$SPasswordField;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public SPasswordField() {
        this.addActionListener(this.controlIssuer);
        this.addFocusListener(this.controlIssuer);
        this.setReadOnly(!Beans.isDesignTime());
    }

    public final boolean isDisableOnNull() {
        return this.disableOnNull;
    }

    public final int getControlSettings() {
        return this.controlIssuer.getControlSettings();
    }

    public final Object getBoundModel() {
        return this.boundModel.getBoundModel();
    }

    public final Selector getSelector() {
        return this.boundModel.getSelector();
    }

    public final String getControlID() {
        return this.controlID;
    }

    public Object getViewValue() throws IllegalArgumentException {
        String string = this.getPasswordText();
        if (this.stringConvertor == null || this.valueIsNull && string.length() < 1) {
            return null;
        }
        return this.stringConvertor.stringAsValue(string);
    }

    public String getPasswordText() {
        return new String(this.getPassword());
    }

    public Controller getController() {
        return null;
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), DEFAULT_ACTIONS);
    }

    public void issueControl(Control control) {
        SwingUtil.issueControl(this, control);
    }

    public final void setControlID(String string) {
        this.controlID = string;
    }

    public final void setControlSettings(int n) {
        this.controlIssuer.setControlSettings(n);
    }

    public final void setDisableOnNull(boolean bl) {
        this.disableOnNull = bl;
    }

    public final void setSelector(Selector selector) {
        this.boundModel.setSelector(selector);
        this.setupStringConvertor();
    }

    public void setEnabled(boolean bl) {
        this.userEnabled = bl;
        super.setEnabled(this.userEnabled && !this.readOnly);
    }

    public void setBoundModel(Object object) {
        this.boundModel.setBoundModel(object);
        this.setupStringConvertor();
    }

    public void setSelector(String string) {
        this.boundModel.setSelector(string);
        this.setupStringConvertor();
    }

    public void setSelectorString(String string) {
        this.setSelector(string);
    }

    public void setStringConvertor(StringConvertor stringConvertor) {
        this.stringConvertor = this.forcedStringConvertor = stringConvertor;
    }

    public void setText(String string) {
        if (!this.getPasswordText().equals(string)) {
            super.setText(string);
        }
    }

    public void setController(Controller controller) {
        throw new UnsupportedOperationException("Can't assign a Controller to a " + this.getClass());
    }

    public void viewChanged() {
        this.boundModel.updateModel();
    }

    public void updateFromProperty(Object object, boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateFromProperty: " + object + ", " + bl);
        }
        this.setupStringConvertor();
        if (this.stringConvertor == null) {
            if (this.getBoundModel() != null) {
                LOG.warn("No StringConvertor found for property " + Selector.asString(this.getSelector()) + " in model " + this.getBoundModel());
            }
            this.valueIsNull = true;
            this.setReadOnly(true);
            this.setText("");
            return;
        }
        this.valueIsNull = object == null;
        try {
            String string = this.stringConvertor.valueAsString(object);
            this.setText(string);
            this.setReadOnly(bl || !this.stringConvertor.supportsStringAsValue() || this.valueIsNull && this.isDisableOnNull());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.error("updateFromProperty", illegalArgumentException);
            this.setReadOnly(true);
        }
    }

    public void validationFailed(Exception exception) {
        this.validationHelper.validationFailed(exception);
    }

    public void validationSuccess() {
        this.validationHelper.validationSuccess();
    }

    public JToolTip createToolTip() {
        return this.validationHelper.createToolTip(super.createToolTip());
    }

    public void refresh() {
        Object object = this.boundModel.getPropertyValue();
        boolean bl = this.boundModel.getPropertyReadOnly();
        this.updateFromProperty(object, bl);
        this.controlIssuer.reset();
    }

    protected void setupStringConvertor() {
        if (this.stringConvertor != null) {
            return;
        }
        if (this.forcedStringConvertor != null) {
            this.stringConvertor = this.forcedStringConvertor;
            return;
        }
        this.stringConvertor = this.createDefaultStringConvertor();
    }

    protected void setReadOnly(boolean bl) {
        this.readOnly = bl;
        super.setEnabled(this.userEnabled && !this.readOnly);
    }

    protected StringConvertor createDefaultStringConvertor() {
        try {
            Object object = this.getBoundModel();
            Selector selector = this.getSelector();
            if (object != null) {
                Class clazz = this.boundModel.getPropertyManager().getPropertyClass(object, selector);
                return StringConvertors.forClass(clazz);
            }
        }
        catch (Exception exception) {
            LOG.warn("createDefaultStringConvertor", exception);
        }
        return null;
    }

    boolean hasNonScopeActionListener() {
        if (this.getControlID() != null) {
            return true;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener == null ? SPasswordField.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener) && !(objectArray[n + 1] instanceof ControlIssuer)) {
                return true;
            }
            n -= 2;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class NotifyAction
    extends TextAction {
        NotifyAction() {
            super("notify-field-accept");
        }

        public boolean isEnabled() {
            SPasswordField sPasswordField;
            boolean bl = false;
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof SPasswordField && !(bl = (sPasswordField = (SPasswordField)jTextComponent).hasNonScopeActionListener())) {
                sPasswordField.viewChanged();
            }
            return bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof SPasswordField) {
                SPasswordField sPasswordField = (SPasswordField)jTextComponent;
                sPasswordField.postActionEvent();
            }
        }
    }
}

