/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.util;

import java.util.Arrays;
import java.util.List;
import org.objectstyle.ashwood.function.DoubleFunction;

public class MedianUtils {
    private MedianUtils() {
    }

    public static double weightedMedianValue(Object o1, Object o2, DoubleFunction valueFunction) {
        return (valueFunction.doubleValue(o1) + valueFunction.doubleValue(o2)) / 2.0;
    }

    public static double weightedMedianValue(List elements, DoubleFunction valueFunction) {
        double leftSpan;
        int size = elements.size();
        switch (size) {
            case 0: {
                return Double.NaN;
            }
            case 1: {
                return valueFunction.doubleValue(elements.get(0));
            }
            case 2: {
                return MedianUtils.weightedMedianValue(elements.get(0), elements.get(1), valueFunction);
            }
        }
        int rightMedian = size / 2;
        double rmValue = valueFunction.doubleValue(elements.get(rightMedian));
        if (size % 2 == 1) {
            return rmValue;
        }
        int leftMedian = rightMedian - 1;
        double lmValue = valueFunction.doubleValue(elements.get(leftMedian));
        double rightSpan = valueFunction.doubleValue(elements.get(size - 1)) - rmValue;
        if (Math.abs(rightSpan - (leftSpan = lmValue - valueFunction.doubleValue(elements.get(0)))) < 1.0E-6) {
            return (lmValue + rmValue) / 2.0;
        }
        return (lmValue * rightSpan + rmValue * leftSpan) / (leftSpan + rightSpan);
    }

    public static double weightedMedianValue(Object[] elements, DoubleFunction valueFunction) {
        return MedianUtils.weightedMedianValue(Arrays.asList(elements), valueFunction);
    }

    public static double weightedMedianValue(double[] elements) {
        int size = elements.length;
        switch (size) {
            case 0: {
                return Double.NaN;
            }
            case 1: {
                return elements[0];
            }
            case 2: {
                return (elements[0] + elements[1]) / 2.0;
            }
        }
        int rightMedian = size / 2;
        double rmValue = elements[rightMedian];
        if (size % 2 == 1) {
            return rmValue;
        }
        double rightSpan = elements[size - 1] - rmValue;
        int leftMedian = rightMedian - 1;
        double lmValue = elements[leftMedian];
        double leftSpan = lmValue - elements[0];
        if (Math.abs(rightSpan - leftSpan) < 1.0E-6) {
            return (lmValue + rmValue) / 2.0;
        }
        return (lmValue * rightSpan + rmValue * leftSpan) / (leftSpan + rightSpan);
    }
}

