/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.hessian.service;

import com.caucho.hessian.io.SerializerFactory;
import com.caucho.services.server.Service;
import com.caucho.services.server.ServiceContext;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cayenne.remote.hessian.EnumSerializerProxy;
import org.apache.cayenne.remote.hessian.HessianConfig;
import org.apache.cayenne.remote.hessian.service.ServerSerializerFactory;
import org.apache.cayenne.remote.service.HttpRemoteService;

public class HessianService
extends HttpRemoteService
implements Service {
    public static final String[] SERVER_SERIALIZER_FACTORIES = new String[]{EnumSerializerProxy.class.getName(), ServerSerializerFactory.class.getName()};

    public void init(ServletConfig config) throws ServletException {
        HashMap<String, String> properties = new HashMap<String, String>();
        Enumeration en = config.getInitParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            properties.put(name, config.getInitParameter(name));
        }
        this.initService(properties);
    }

    SerializerFactory createSerializerFactory() {
        return HessianConfig.createFactory(SERVER_SERIALIZER_FACTORIES, this.getRootChannel().getEntityResolver());
    }

    protected HttpSession getSession(boolean create) {
        HttpServletRequest request = (HttpServletRequest)ServiceContext.getContextRequest();
        if (request == null) {
            throw new IllegalStateException("Attempt to access HttpSession outside the request scope.");
        }
        return request.getSession(create);
    }

    public void destroy() {
        this.destroyService();
    }
}

