/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.FindDialog;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.query.Query;

public class FindAction
extends CayenneAction {
    private List<Object> paths;

    public static String getActionName() {
        return "Find";
    }

    public FindAction(Application application) {
        super(FindAction.getActionName(), application);
    }

    public void performAction(ActionEvent e) {
        Object[] path;
        JTextField source = (JTextField)e.getSource();
        this.paths = new ArrayList<Object>();
        if (!source.getText().trim().equals("")) {
            Pattern pattern = Pattern.compile(source.getText().trim(), 2);
            Iterator it = this.getProjectController().getProject().treeNodes();
            while (it.hasNext()) {
                path = (Object[])it.next();
                Object o = path.getObject();
                if ((o instanceof ObjEntity || o instanceof DbEntity) && this.matchFound(((Entity)o).getName(), pattern)) {
                    this.paths.add(path.getPath());
                    continue;
                }
                if (o instanceof Attribute && this.matchFound(((Attribute)o).getName(), pattern)) {
                    this.paths.add(path.getPath());
                    continue;
                }
                if (o instanceof Relationship && this.matchFound(((Relationship)o).getName(), pattern)) {
                    this.paths.add(path.getPath());
                    continue;
                }
                if (o instanceof Query && this.matchFound(((Query)o).getName(), pattern)) {
                    this.paths.add(path.getPath());
                    continue;
                }
                if (o instanceof Embeddable && this.matchFound(((Embeddable)o).getClassName(), pattern)) {
                    this.paths.add(path.getPath());
                    continue;
                }
                if (!(o instanceof EmbeddableAttribute) || !this.matchFound(((EmbeddableAttribute)o).getName(), pattern)) continue;
                this.paths.add(path.getPath());
            }
        }
        if (this.paths.size() == 0) {
            source.setBackground(Color.pink);
        } else if (this.paths.size() != 1) {
            new FindDialog(this.getApplication().getFrameController(), this.paths).startupAction();
        } else {
            Iterator<Object> it = this.paths.iterator();
            boolean index = false;
            if (it.hasNext()) {
                path = (Object[])it.next();
                FindDialog.jumpToResult(path);
            }
        }
    }

    private boolean matchFound(String entityName, Pattern pattern) {
        Matcher m = pattern.matcher(entityName);
        return m.find();
    }
}

