/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.pref.Domain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeTemplateManager {
    public static final String STANDARD_SERVER_SUPERCLASS = "Standard Server Superclass";
    public static final String STANDARD_SERVER_SUBCLASS = "Standard Server Subclass";
    static final String STANDARD_CLIENT_SUPERCLASS = "Standard Client Superclass";
    static final String STANDARD_CLIENT_SUBCLASS = "Standard Client Subclass";
    protected List<String> standardSubclassTemplates;
    protected List<String> standardSuperclassTemplates = new ArrayList<String>(3);
    protected Map<String, String> customTemplates;
    protected Map<String, String> standardTemplates;
    protected Map<String, String> standardTemplates1_1;

    public static Domain getTemplateDomain(Application application) {
        return application.getPreferenceDomain().getSubdomain(CodeTemplateManager.class);
    }

    public CodeTemplateManager(Application application) {
        this.standardSuperclassTemplates.add(STANDARD_SERVER_SUPERCLASS);
        this.standardSuperclassTemplates.add(STANDARD_CLIENT_SUPERCLASS);
        this.standardSubclassTemplates = new ArrayList<String>(3);
        this.standardSubclassTemplates.add(STANDARD_SERVER_SUBCLASS);
        this.standardSubclassTemplates.add(STANDARD_CLIENT_SUBCLASS);
        this.updateCustomTemplates(CodeTemplateManager.getTemplateDomain(application));
        this.standardTemplates = new HashMap<String, String>();
        this.standardTemplates.put(STANDARD_SERVER_SUPERCLASS, "dotemplates/v1_2/superclass.vm");
        this.standardTemplates.put(STANDARD_CLIENT_SUPERCLASS, "dotemplates/v1_2/client-superclass.vm");
        this.standardTemplates.put(STANDARD_SERVER_SUBCLASS, "dotemplates/v1_2/subclass.vm");
        this.standardTemplates.put(STANDARD_CLIENT_SUBCLASS, "dotemplates/v1_2/client-subclass.vm");
        this.standardTemplates1_1 = new HashMap<String, String>();
        this.standardTemplates1_1.put(STANDARD_SERVER_SUPERCLASS, "dotemplates/superclass.vm");
        this.standardTemplates1_1.put(STANDARD_CLIENT_SUPERCLASS, "dotemplates/v1_2/client-superclass.vm");
        this.standardTemplates1_1.put(STANDARD_SERVER_SUBCLASS, "dotemplates/subclass.vm");
        this.standardTemplates1_1.put(STANDARD_CLIENT_SUBCLASS, "dotemplates/v1_2/client-subclass.vm");
    }

    public void updateCustomTemplates(Domain preferenceDomain) {
        Map templates = preferenceDomain.getDetailsMap(FSPath.class);
        this.customTemplates = new HashMap<String, String>(templates.size(), 1.0f);
        for (Map.Entry entry : templates.entrySet()) {
            FSPath path = (FSPath)entry.getValue();
            this.customTemplates.put((String)entry.getKey(), path.getPath());
        }
    }

    public String getTemplatePath(String name, String version) {
        String value = this.customTemplates.get(name);
        if (value != null) {
            return value.toString();
        }
        Map<String, String> templates = "1.1".equals(version) ? this.standardTemplates1_1 : this.standardTemplates;
        value = templates.get(name);
        return value != null ? value.toString() : null;
    }

    public Map<String, String> getCustomTemplates() {
        return this.customTemplates;
    }

    public List<String> getStandardSubclassTemplates() {
        return this.standardSubclassTemplates;
    }

    public List<String> getStandardSuperclassTemplates() {
        return this.standardSuperclassTemplates;
    }
}

