/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.conf.ResourceFinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathResourceFinder
implements ResourceFinder {
    static final Log logger = LogFactory.getLog(ClasspathResourceFinder.class);
    protected ClassLoader classLoader;
    protected Collection<String> rootPaths = new LinkedHashSet<String>(2);

    public ClasspathResourceFinder() {
        this.rootPaths.add("");
    }

    @Override
    public URL getResource(String name) {
        if (name == null) {
            throw new NullPointerException("Null resource name");
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        ClassLoader loader = this.getResourceClassLoader();
        for (String root : this.rootPaths) {
            String fullName = root.length() > 0 ? root + "/" + name : name;
            logger.debug("searching for resource under: " + fullName);
            URL url = loader.getResource(fullName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Collection<URL> getResources(String name) {
        if (name == null) {
            throw new NullPointerException("Null resource name");
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        ClassLoader loader = this.getResourceClassLoader();
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        for (String root : this.rootPaths) {
            Enumeration<URL> urlsEn;
            String fullName = root.length() > 0 ? root + "/" + name : name;
            logger.debug("searching for resources under: " + fullName);
            try {
                urlsEn = loader.getResources(fullName);
            }
            catch (IOException e) {
                throw new CayenneRuntimeException("Error reading URL resources from " + fullName);
            }
            while (urlsEn.hasMoreElements()) {
                urls.add(urlsEn.nextElement());
            }
        }
        return urls;
    }

    public void addRootPath(String path) {
        if (path == null) {
            throw new NullPointerException("Null path");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.rootPaths.add(path);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected ClassLoader getResourceClassLoader() {
        ClassLoader loader = this.classLoader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if (loader == null) {
            throw new IllegalStateException("Can't detect ClassLoader to use for resouyrce location");
        }
        return loader;
    }
}

