/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.List;
import org.apache.cayenne.map.CallbackDescriptor;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;
import org.apache.cayenne.modeler.util.CayenneTableModel;

public class CallbackDescriptorTableModel
extends CayenneTableModel {
    private static final int COLUMN_COUNT = 1;
    public static final int METHOD_NAME = 0;
    protected ObjEntity entity;
    protected CallbackDescriptor callbackDescriptor;

    public CallbackDescriptorTableModel(ProjectController mediator, Object eventSource, List objectList, CallbackDescriptor callbackDescriptor) {
        super(mediator, eventSource, objectList);
        this.callbackDescriptor = callbackDescriptor;
    }

    public void setUpdatedValueAt(Object newVal, int row, int col) {
    }

    public Class getElementsClass() {
        return String.class;
    }

    public String getCallbackMethod(int rowIndex) {
        return (String)this.objectList.get(rowIndex);
    }

    public int getColumnCount() {
        return 1;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getCallbackMethod(rowIndex);
            }
        }
        return null;
    }

    protected void orderList() {
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Method";
            }
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void setValueAt(Object newVal, int row, int col) {
        String method = (String)newVal;
        if (method != null) {
            method = method.trim();
        }
        String prevMethod = (String)this.getObjectList().get(row);
        if (method != null && method.length() > 0 && !method.equals(prevMethod) && !this.getCallbackDescriptor().getCallbackMethods().contains(method)) {
            this.getObjectList().set(row, method);
            this.getCallbackDescriptor().setCallbackMethodAt(row, method);
            this.fireTableRowsUpdated(row, row);
            this.mediator.fireCallbackMethodEvent(new CallbackMethodEvent(this.eventSource, prevMethod, method, 1));
        }
    }

    public CallbackDescriptor getCallbackDescriptor() {
        return this.callbackDescriptor;
    }
}

