/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipInfoModel;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipPathBrowser;
import org.apache.cayenne.modeler.util.EntityTreeFilter;
import org.apache.cayenne.modeler.util.EntityTreeModel;
import org.apache.cayenne.modeler.util.MultiColumnBrowser;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.scopemvc.view.swing.SAction;
import org.scopemvc.view.swing.SButton;
import org.scopemvc.view.swing.SComboBox;
import org.scopemvc.view.swing.SLabel;
import org.scopemvc.view.swing.SListCellRenderer;
import org.scopemvc.view.swing.SPanel;
import org.scopemvc.view.swing.STextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjRelationshipInfoDialog
extends SPanel {
    static final Dimension BROWSER_CELL_DIM = new Dimension(130, 200);
    protected MultiColumnBrowser pathBrowser;
    protected Component collectionTypeLabel;
    protected SComboBox collectionTypeCombo;
    protected Component mapKeysLabel;
    protected SComboBox mapKeysCombo;

    public ObjRelationshipInfoDialog() {
        this.init();
    }

    protected void init() {
        SButton saveButton = new SButton(new SAction("cayenne.modeler.mapObjRelationship.save.button"));
        saveButton.setEnabled(true);
        SButton cancelButton = new SButton(new SAction("cayenne.modeler.mapObjRelationship.cancel.button"));
        cancelButton.setEnabled(true);
        SButton newRelButton = new SButton(new SAction("cayenne.modeler.mapObjRelationship.newrel.button"));
        newRelButton.setEnabled(true);
        SButton selectPathButton = new SButton(new SAction("cayenne.modeler.mapObjRelationship.select.path.button"));
        selectPathButton.setEnabled(true);
        STextField relationshipName = new STextField(25);
        relationshipName.setSelector(ObjRelationshipInfoModel.RELATIONSHIP_NAME_SELECTOR);
        SLabel currentPathLabel = new SLabel();
        currentPathLabel.setSelector(ObjRelationshipInfoModel.CURRENT_PATH_SELECTOR);
        SLabel sourceEntityLabel = new SLabel();
        sourceEntityLabel.setSelector(ObjRelationshipInfoModel.SOURCE_ENTITY_NAME_SELECTOR);
        SComboBox targetCombo = new SComboBox();
        targetCombo.setSelector(ObjRelationshipInfoModel.OBJECT_TARGETS_SELECTOR);
        targetCombo.setSelectionSelector(ObjRelationshipInfoModel.OBJECT_TARGET_SELECTOR);
        SListCellRenderer renderer = (SListCellRenderer)targetCombo.getRenderer();
        renderer.setTextSelector("name");
        this.collectionTypeCombo = new SComboBox();
        this.collectionTypeCombo.setSelector(ObjRelationshipInfoModel.TARGET_COLLECTIONS_SELECTOR);
        this.collectionTypeCombo.setSelectionSelector(ObjRelationshipInfoModel.TARGET_COLLECTION_SELECTOR);
        this.mapKeysCombo = new SComboBox();
        this.mapKeysCombo.setSelector(ObjRelationshipInfoModel.MAP_KEYS_SELECTOR);
        this.mapKeysCombo.setSelectionSelector(ObjRelationshipInfoModel.MAP_KEY_SELECTOR);
        this.pathBrowser = new ObjRelationshipPathBrowser();
        this.pathBrowser.setPreferredColumnSize(BROWSER_CELL_DIM);
        this.pathBrowser.setDefaultRenderer();
        this.collectionTypeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                ObjRelationshipInfoDialog.this.updateCollectionChoosers();
            }
        });
        this.setDisplayMode(1);
        this.setTitle("ObjRelationship Inspector");
        this.setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("right:max(50dlu;pref), 3dlu, fill:min(150dlu;pref), 3dlu, 300dlu, 3dlu, fill:min(120dlu;pref)", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, top:14dlu, 3dlu, top:p:grow"));
        builder.setDefaultDialogBorder();
        builder.addSeparator("ObjRelationship Information", cc.xywh(1, 1, 5, 1));
        builder.addLabel("Relationship:", cc.xy(1, 3));
        builder.add((Component)relationshipName, cc.xywh(3, 3, 1, 1));
        builder.addLabel("Current Db Path:", cc.xy(1, 5));
        builder.add((Component)currentPathLabel, cc.xywh(3, 5, 5, 1));
        builder.addLabel("Source:", cc.xy(1, 7));
        builder.add((Component)sourceEntityLabel, cc.xywh(3, 7, 1, 1));
        builder.addLabel("Target:", cc.xy(1, 9));
        builder.add((Component)targetCombo, cc.xywh(3, 9, 1, 1));
        this.collectionTypeLabel = builder.addLabel("Collection Type:", cc.xy(1, 11));
        builder.add((Component)this.collectionTypeCombo, cc.xywh(3, 11, 1, 1));
        this.mapKeysLabel = builder.addLabel("Map Key:", cc.xy(1, 13));
        builder.add((Component)this.mapKeysCombo, cc.xywh(3, 13, 1, 1));
        builder.addSeparator("Mapping to DbRelationships", cc.xywh(1, 15, 5, 1));
        JPanel buttonsPane = new JPanel(new FlowLayout(3));
        buttonsPane.add((Component)selectPathButton);
        buttonsPane.add((Component)newRelButton);
        builder.add((Component)buttonsPane, cc.xywh(1, 17, 5, 1));
        builder.add((Component)new JScrollPane(this.pathBrowser, 20, 30), cc.xywh(1, 19, 5, 3));
        this.add(builder.getPanel(), "Center");
        this.add(PanelFactory.createButtonPanel(new JButton[]{saveButton, cancelButton}), "South");
    }

    public MultiColumnBrowser getPathBrowser() {
        return this.pathBrowser;
    }

    void initFromModel() {
        if (!this.updateCollectionChoosers()) {
            return;
        }
        ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)((Object)this.getController().getModel());
        if (this.pathBrowser.getModel() == null) {
            EntityTreeModel treeModel = new EntityTreeModel((Entity)model.getStartEntity());
            treeModel.setFilter(new EntityTreeFilter(){

                public boolean attributeMatch(Object node, Attribute attr) {
                    return false;
                }

                public boolean relationshipMatch(Object node, Relationship rel) {
                    if (!(node instanceof Relationship)) {
                        return true;
                    }
                    DbRelationship prev = (DbRelationship)node;
                    return rel.isToMany() || prev.getReverseRelationship() != rel;
                }
            });
            this.pathBrowser.setModel(treeModel);
            this.setSelectionPath(model.getSavedDbRelationships());
        }
    }

    void setSelectionPath(List<DbRelationship> rels) {
        ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)((Object)this.getController().getModel());
        Object[] path = new Object[rels.size() + 1];
        path[0] = model.getStartEntity();
        System.arraycopy(rels.toArray(), 0, path, 1, rels.size());
        this.pathBrowser.setSelectionPath(new TreePath(path));
    }

    boolean updateCollectionChoosers() {
        if (this.getController() == null || this.getController().getModel() == null) {
            return false;
        }
        ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)((Object)this.getController().getModel());
        boolean collectionTypeEnabled = model.isToMany();
        this.collectionTypeCombo.setEnabled(collectionTypeEnabled);
        this.collectionTypeLabel.setEnabled(collectionTypeEnabled);
        boolean mapKeysEnabled = collectionTypeEnabled && "java.util.Map".equals(this.collectionTypeCombo.getSelectedItem());
        this.mapKeysCombo.setEnabled(mapKeysEnabled);
        this.mapKeysLabel.setEnabled(mapKeysEnabled);
        return true;
    }
}

