/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.select;

import java.sql.ResultSet;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.select.RowReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompoundRowReader
implements RowReader<Object[]> {
    private RowReader<?>[] readers;

    CompoundRowReader(int width) {
        this.readers = new RowReader[width];
    }

    void addRowReader(int pos, RowReader<?> reader) {
        this.readers[pos] = reader;
    }

    @Override
    public void setColumnOffset(int offset) {
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setColumnOffset(offset);
        }
    }

    @Override
    public Object[] readRow(ResultSet resultSet) throws CayenneException {
        int width = this.readers.length;
        Object[] row = new Object[width];
        for (int i = 0; i < width; ++i) {
            row[i] = this.readers[i].readRow(resultSet);
        }
        return row;
    }
}

