/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.QueryCacheStrategy;

class EJBQLQueryMetadata
extends BaseQueryMetadata {
    EJBQLQueryMetadata() {
    }

    boolean resolve(EntityResolver resolver, EJBQLQuery query) {
        Map<Integer, Object> positionalParameters;
        Map<String, Object> namedParameters;
        EJBQLCompiledExpression expression = query.getExpression(resolver);
        this.setPrefetchTree(expression.getPrefetchTree());
        this.resultSetMapping = expression.getResult() != null ? expression.getResult().getResolvedComponents(resolver) : null;
        ObjEntity root = expression.getRootDescriptor().getEntity();
        if (!super.resolve(root, resolver)) {
            return false;
        }
        if (QueryCacheStrategy.NO_CACHE == this.getCacheStrategy()) {
            return true;
        }
        StringBuilder key = new StringBuilder();
        if (query.getEjbqlStatement() != null) {
            key.append('/').append(query.getEjbqlStatement());
        }
        if (query.getFetchLimit() > 0) {
            key.append('/').append(query.getFetchLimit());
        }
        if (!(namedParameters = query.getNamedParameters()).isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>(namedParameters.keySet());
            Collections.sort(keys);
            for (String parameterKey : keys) {
                key.append('/').append(parameterKey).append('=').append(namedParameters.get(parameterKey));
            }
        }
        if (!(positionalParameters = query.getPositionalParameters()).isEmpty()) {
            ArrayList<Integer> keys = new ArrayList<Integer>(positionalParameters.keySet());
            Collections.sort(keys);
            for (Integer parameterKey : keys) {
                key.append('/').append(parameterKey).append('=').append(positionalParameters.get(parameterKey));
            }
        }
        if (query.getFetchOffset() > 0 || query.getFetchLimit() > 0) {
            key.append('/');
            if (query.getFetchOffset() > 0) {
                key.append('o').append(query.getFetchOffset());
            }
            if (query.getFetchLimit() > 0) {
                key.append('l').append(query.getFetchLimit());
            }
        }
        this.cacheKey = key.toString();
        return true;
    }
}

