/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.nio.file.Paths;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorController;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.validation.ValidationException;

public class GeneratorControllerPanel
extends JPanel {
    protected TextAdapter outputFolder;
    protected JButton selectOutputFolder;
    protected ProjectController projectController;
    protected CodeGeneratorController codeGeneratorController;

    public GeneratorControllerPanel(ProjectController projectController, CodeGeneratorController codeGeneratorController) {
        this.projectController = projectController;
        this.codeGeneratorController = codeGeneratorController;
        this.outputFolder = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) throws ValidationException {
                CgenConfiguration cgenByDataMap = GeneratorControllerPanel.this.getCgenConfig();
                if (cgenByDataMap != null) {
                    if (cgenByDataMap.getRootPath() == null && !Paths.get(text, new String[0]).isAbsolute()) {
                        throw new ValidationException("You should save project to use rel path as output directory ", new Object[0]);
                    }
                    cgenByDataMap.setRelPath(text);
                    GeneratorControllerPanel.this.checkConfigDirty();
                }
            }
        };
        this.selectOutputFolder = new JButton("..");
    }

    public TextAdapter getOutputFolder() {
        return this.outputFolder;
    }

    public JButton getSelectOutputFolder() {
        return this.selectOutputFolder;
    }

    protected void checkConfigDirty() {
        if (!this.codeGeneratorController.isInitFromModel()) {
            this.codeGeneratorController.checkCgenConfigDirty();
        }
    }

    protected CgenConfiguration getCgenConfig() {
        return this.codeGeneratorController.getCgenConfiguration();
    }
}

