/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.EjbqlQueryMainTab;
import org.apache.cayenne.modeler.editor.EjbqlQueryScriptsTab;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;

public class EjbqlTabbedView
extends JTabbedPane {
    protected ProjectController mediator;
    protected EjbqlQueryMainTab mainTab;
    protected EjbqlQueryScriptsTab scriptsTab;
    protected int lastSelectionIndex;

    public EjbqlTabbedView(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.setTabPlacement(1);
        this.mainTab = new EjbqlQueryMainTab(this.mediator);
        this.addTab("General", new JScrollPane(this.mainTab));
        this.scriptsTab = new EjbqlQueryScriptsTab(this.mediator);
        this.addTab("EJBQL", this.scriptsTab);
    }

    private void initController() {
        this.mediator.addQueryDisplayListener(new QueryDisplayListener(){

            @Override
            public void currentQueryChanged(QueryDisplayEvent e) {
                EjbqlTabbedView.this.initFromModel();
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EjbqlTabbedView.this.lastSelectionIndex = EjbqlTabbedView.this.getSelectedIndex();
                EjbqlTabbedView.this.updateTabs();
            }
        });
    }

    void initFromModel() {
        if (!"EJBQLQuery".equals(this.mediator.getCurrentQuery().getType())) {
            this.setVisible(false);
            return;
        }
        if (this.getSelectedIndex() == this.lastSelectionIndex) {
            this.updateTabs();
        } else {
            this.setSelectedIndex(this.lastSelectionIndex);
        }
        this.setVisible(true);
    }

    void updateTabs() {
        switch (this.lastSelectionIndex) {
            case 0: {
                this.mainTab.initFromModel();
                break;
            }
            case 1: {
                this.scriptsTab.initFromModel();
            }
        }
    }
}

