/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph;

import java.util.HashMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.graph.GraphBuilder;
import org.apache.cayenne.modeler.graph.GraphType;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class GraphMap
extends HashMap<GraphType, GraphBuilder>
implements XMLSerializable {
    GraphType selectedType;
    DataChannelDescriptor domain;

    public GraphMap(DataChannelDescriptor domain) {
        this.domain = domain;
    }

    public DataChannelDescriptor getDomain() {
        return this.domain;
    }

    public GraphType getSelectedType() {
        return this.selectedType;
    }

    public void setSelectedType(GraphType selectedType) {
        this.selectedType = selectedType;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<graphs");
        encoder.println(">");
        encoder.indent(1);
        for (GraphBuilder builder : this.values()) {
            builder.encodeAsXML(encoder);
        }
        encoder.indent(-1);
        encoder.println("</graphs>");
    }

    public GraphBuilder createGraphBuilder(GraphType type, boolean doLayout) {
        try {
            GraphBuilder builder = type.getBuilderClass().newInstance();
            builder.buildGraph(this.getProjectController(), this.domain, doLayout);
            this.put(type, builder);
            return builder;
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Could not instantiate GraphBuilder", (Throwable)e, new Object[0]);
        }
    }

    private ProjectController getProjectController() {
        return Application.getInstance().getFrameController().getProjectController();
    }
}

