/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SelectPropertiesPanel
extends JPanel {
    private static Logger logObj = LoggerFactory.getLogger(SelectPropertiesPanel.class);
    private static final Integer ZERO = 0;
    private static final String NO_CACHE_LABEL = "No Result Caching";
    private static final String LOCAL_CACHE_LABEL = "Local Cache (per ObjectContext)";
    private static final String SHARED_CACHE_LABEL = "Shared Cache";
    protected static final Object[] CACHE_POLICIES = new Object[]{QueryCacheStrategy.NO_CACHE, QueryCacheStrategy.LOCAL_CACHE, QueryCacheStrategy.SHARED_CACHE};
    private static final Map<QueryCacheStrategy, String> cachePolicyLabels = new TreeMap<QueryCacheStrategy, String>();
    protected TextAdapter fetchOffset;
    protected TextAdapter fetchLimit;
    protected TextAdapter pageSize;
    protected JComboBox cacheStrategy;
    protected TextAdapter cacheGroups;
    protected JComponent cacheGroupsLabel;
    protected ProjectController mediator;

    public SelectPropertiesPanel(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    protected void initView() {
        this.fetchOffset = new TextAdapter(new JTextField(7)){

            @Override
            protected void updateModel(String text) {
                SelectPropertiesPanel.this.setFetchOffset(text);
            }
        };
        this.fetchLimit = new TextAdapter(new JTextField(7)){

            @Override
            protected void updateModel(String text) {
                SelectPropertiesPanel.this.setFetchLimit(text);
            }
        };
        this.pageSize = new TextAdapter(new JTextField(7)){

            @Override
            protected void updateModel(String text) {
                SelectPropertiesPanel.this.setPageSize(text);
            }
        };
        this.cacheStrategy = Application.getWidgetFactory().createUndoableComboBox();
        this.cacheStrategy.setRenderer(new CacheStrategyRenderer());
        this.cacheGroups = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                SelectPropertiesPanel.this.setCacheGroups(text);
            }
        };
    }

    protected void initController() {
        this.cacheStrategy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                QueryCacheStrategy strategy = (QueryCacheStrategy)((Object)SelectPropertiesPanel.this.cacheStrategy.getModel().getSelectedItem());
                SelectPropertiesPanel.this.setQueryProperty("cayenne.GenericSelectQuery.cacheStrategy", strategy.name());
                SelectPropertiesPanel.this.setCacheGroupsEnabled(strategy != QueryCacheStrategy.NO_CACHE);
            }
        });
    }

    public void initFromModel(QueryDescriptor query) {
        DefaultComboBoxModel<Object> cacheModel = new DefaultComboBoxModel<Object>(CACHE_POLICIES);
        String selectedStrategyString = query.getProperty("cayenne.GenericSelectQuery.cacheStrategy");
        QueryCacheStrategy selectedStrategy = selectedStrategyString != null ? QueryCacheStrategy.valueOf(selectedStrategyString) : null;
        cacheModel.setSelectedItem((Object)(selectedStrategy != null ? selectedStrategy : QueryCacheStrategy.getDefaultStrategy()));
        this.cacheStrategy.setModel(cacheModel);
        this.cacheGroups.setText(query.getProperty("cayenne.GenericSelectQuery.cacheGroups"));
        this.setCacheGroupsEnabled(selectedStrategy != null && selectedStrategy != QueryCacheStrategy.NO_CACHE);
        String fetchOffsetStr = query.getProperty("cayenne.GenericSelectQuery.fetchOffset");
        String fetchLimitStr = query.getProperty("cayenne.GenericSelectQuery.fetchLimit");
        String pageSizeStr = query.getProperty("cayenne.GenericSelectQuery.pageSize");
        this.fetchOffset.setText(fetchOffsetStr != null ? fetchOffsetStr : ZERO.toString());
        this.fetchLimit.setText(fetchLimitStr != null ? fetchLimitStr : ZERO.toString());
        this.pageSize.setText(pageSizeStr != null ? pageSizeStr : ZERO.toString());
    }

    void setFetchOffset(String string) {
        String string2 = string = string == null ? "" : string.trim();
        if (string.length() == 0) {
            this.setQueryProperty("cayenne.GenericSelectQuery.fetchOffset", ZERO.toString());
        } else if (StringUtils.isNumeric(string)) {
            this.setQueryProperty("cayenne.GenericSelectQuery.fetchOffset", string);
        } else {
            throw new ValidationException("Fetch offset must be an integer: %s", string);
        }
    }

    void setFetchLimit(String string) {
        String string2 = string = string == null ? "" : string.trim();
        if (string.length() == 0) {
            this.setQueryProperty("cayenne.GenericSelectQuery.fetchLimit", ZERO.toString());
        } else if (StringUtils.isNumeric(string)) {
            this.setQueryProperty("cayenne.GenericSelectQuery.fetchLimit", string);
        } else {
            throw new ValidationException("Fetch limit must be an integer: %s", string);
        }
    }

    void setPageSize(String string) {
        String string2 = string = string == null ? "" : string.trim();
        if (string.length() == 0) {
            this.setQueryProperty("cayenne.GenericSelectQuery.pageSize", ZERO.toString());
        } else if (StringUtils.isNumeric(string)) {
            this.setQueryProperty("cayenne.GenericSelectQuery.pageSize", string);
        } else {
            throw new ValidationException("Page size must be an integer: %s", string);
        }
    }

    void setCacheGroups(String string) {
        string = string == null ? "" : string.trim();
        this.setQueryProperty("cayenne.GenericSelectQuery.cacheGroups", string);
    }

    QueryDescriptor getQuery() {
        return this.mediator.getCurrentQuery();
    }

    @Override
    public void setEnabled(boolean flag) {
        Component[] children;
        super.setEnabled(flag);
        Container mainPanel = (Container)this.getComponent(0);
        for (Component child : children = mainPanel.getComponents()) {
            child.setEnabled(flag);
        }
    }

    protected void setCacheGroupsEnabled(boolean enabled) {
        this.cacheGroups.getComponent().setEnabled(enabled);
        this.cacheGroupsLabel.setEnabled(enabled);
    }

    void setQueryProperty(String property, String value) {
        QueryDescriptor query = this.getQuery();
        if (query != null) {
            try {
                String old = query.getProperty(property);
                if (Util.nullSafeEquals(value, old)) {
                    return;
                }
                query.setProperty(property, value);
                this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
            }
            catch (Exception ex) {
                logObj.warn("Error setting property: " + property, ex);
            }
        }
    }

    static {
        cachePolicyLabels.put(QueryCacheStrategy.NO_CACHE, NO_CACHE_LABEL);
        cachePolicyLabels.put(QueryCacheStrategy.LOCAL_CACHE, LOCAL_CACHE_LABEL);
        cachePolicyLabels.put(QueryCacheStrategy.SHARED_CACHE, SHARED_CACHE_LABEL);
    }

    final class CacheStrategyRenderer
    extends DefaultListCellRenderer {
        CacheStrategyRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object object, int arg2, boolean arg3, boolean arg4) {
            if (object != null) {
                object = cachePolicyLabels.get(object);
            }
            if (object == null) {
                object = SelectPropertiesPanel.NO_CACHE_LABEL;
            }
            return super.getListCellRendererComponent((JList<?>)list, object, arg2, arg3, arg4);
        }
    }
}

