/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.dialog.codegen.ClassesTabPanel;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ImageRendererColumn;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.swing.TableBindingBuilder;
import org.apache.cayenne.util.XMLSerializable;
import org.apache.commons.collections.Predicate;

public class ClassesTabController
extends CayenneController {
    public static final String GENERATE_PROPERTY = "generate";
    protected ClassesTabPanel view;
    protected ObjectBinding tableBinding;
    protected Collection<DataMap> dataMaps;
    protected Map<DataMap, List<Object>> objectList;
    private Map<DataMap, ObjectBinding> objectBindings;
    private List<Object> currentCollection = new ArrayList<Object>();

    public ClassesTabController(CodeGeneratorControllerBase parent, Collection<DataMap> dataMaps) {
        super(parent);
        this.objectList = new HashMap<DataMap, List<Object>>();
        for (DataMap dataMap : dataMaps) {
            ArrayList<XMLSerializable> list = new ArrayList<XMLSerializable>();
            list.add(dataMap);
            list.addAll(dataMap.getObjEntities());
            list.addAll(dataMap.getEmbeddables());
            this.objectList.put(dataMap, list);
        }
        this.objectBindings = new HashMap<DataMap, ObjectBinding>();
        this.dataMaps = dataMaps;
        this.view = new ClassesTabPanel(dataMaps);
        this.initBindings();
    }

    protected CodeGeneratorControllerBase getParentController() {
        return (CodeGeneratorControllerBase)this.getParent();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getCheckAll(), "checkAllAction()");
        TableBindingBuilder tableBuilder = new TableBindingBuilder(builder);
        tableBuilder.addColumn("", "parent.setCurrentClass(#item), selected", Boolean.class, true, Boolean.TRUE);
        tableBuilder.addColumn("Class", "parent.getItemName(#item)", JLabel.class, false, "XXXXXXXXXXXXXX");
        tableBuilder.addColumn("Comments, Warnings", "parent.getProblem(#item)", String.class, false, "XXXXXXXXXXXXXXXXXXXXXXXXXXX");
        for (final DataMap dataMap : this.dataMaps) {
            if (this.view.getDataMapTables().get(dataMap) != null) {
                this.currentCollection = this.objectList.get(dataMap);
                this.objectBindings.put(dataMap, tableBuilder.bindToTable(this.view.getDataMapTables().get(dataMap), "currentCollection"));
                this.view.getDataMapTables().get(dataMap).getColumnModel().getColumn(1).setCellRenderer(new ImageRendererColumn());
            }
            if (this.view.getDataMapJCheckBoxMap().get(dataMap) == null) continue;
            this.view.getDataMapJCheckBoxMap().get(dataMap).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent val) {
                    ClassesTabController.this.checkDataMap(dataMap, ((JCheckBox)val.getSource()).isSelected());
                }
            });
        }
    }

    public List<Object> getCurrentCollection() {
        return this.currentCollection;
    }

    public boolean isSelected() {
        return this.getParentController().isSelected();
    }

    public void setSelected(boolean selected) {
        this.getParentController().setSelected(selected);
        this.classSelectedAction();
        for (DataMap dataMap : this.dataMaps) {
            if (this.view.isAllCheckBoxesFromDataMapSelected(dataMap)) {
                this.view.getDataMapJCheckBoxMap().get(dataMap).setSelected(true);
                continue;
            }
            this.view.getDataMapJCheckBoxMap().get(dataMap).setSelected(false);
        }
    }

    public void classSelectedAction() {
        int selectedCount = this.getParentController().getSelectedEntitiesSize() + this.getParentController().getSelectedEmbeddablesSize() + this.getParentController().getSelectedDataMapsSize();
        if (selectedCount == 0) {
            this.view.getCheckAll().setSelected(false);
        } else if (selectedCount == this.getParentController().getClasses().size()) {
            this.view.getCheckAll().setSelected(true);
        }
    }

    public void checkAllAction() {
        if (this.getParentController().updateSelection(this.view.getCheckAll().isSelected() ? new Predicate(){

            @Override
            public boolean evaluate(Object o) {
                return true;
            }
        } : new Predicate(){

            @Override
            public boolean evaluate(Object o) {
                return false;
            }
        })) {
            for (DataMap dataMap : this.dataMaps) {
                if (this.objectBindings.get(dataMap) == null) continue;
                this.currentCollection = this.objectList.get(dataMap);
                this.objectBindings.get(dataMap).updateView();
            }
        }
    }

    private void checkDataMap(DataMap dataMap, boolean selected) {
        if (this.getParentController().updateDataMapSelection(selected ? new Predicate(){

            @Override
            public boolean evaluate(Object o) {
                return true;
            }
        } : new Predicate(){

            @Override
            public boolean evaluate(Object o) {
                return false;
            }
        }, dataMap)) {
            if (this.objectBindings.get(dataMap) != null) {
                this.currentCollection = this.objectList.get(dataMap);
                this.objectBindings.get(dataMap).updateView();
            }
            if (this.isAllMapsSelected()) {
                this.view.getCheckAll().setSelected(true);
            }
        }
    }

    private boolean isAllMapsSelected() {
        for (DataMap dataMap : this.dataMaps) {
            if (this.view.getDataMapJCheckBoxMap().get(dataMap) == null || this.view.getDataMapJCheckBoxMap().get(dataMap).isSelected()) continue;
            return false;
        }
        return true;
    }
}

