/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.disk;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.index.sasi.disk.Descriptor;
import org.apache.cassandra.index.sasi.disk.Token;
import org.apache.cassandra.index.sasi.disk.TokenTreeBuilder;
import org.apache.cassandra.index.sasi.utils.CombinedValue;
import org.apache.cassandra.index.sasi.utils.MappedBuffer;
import org.apache.cassandra.index.sasi.utils.RangeIterator;
import org.apache.cassandra.utils.AbstractGuavaIterator;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class TokenTree {
    private static final int LONG_BYTES = 8;
    private static final int SHORT_BYTES = 2;
    private final Descriptor descriptor;
    private final MappedBuffer file;
    private final long startPos;
    private final long treeMinToken;
    private final long treeMaxToken;
    private final long tokenCount;

    @VisibleForTesting
    protected TokenTree(MappedBuffer tokenTree) {
        this(Descriptor.CURRENT, tokenTree);
    }

    public TokenTree(Descriptor d, MappedBuffer tokenTree) {
        this.descriptor = d;
        this.file = tokenTree;
        this.startPos = this.file.position();
        this.file.position(this.startPos + 19L);
        if (!this.validateMagic()) {
            throw new IllegalArgumentException("invalid token tree");
        }
        this.tokenCount = this.file.getLong();
        this.treeMinToken = this.file.getLong();
        this.treeMaxToken = this.file.getLong();
    }

    public long getCount() {
        return this.tokenCount;
    }

    public RangeIterator<Long, Token> iterator(Function<Long, DecoratedKey> keyFetcher) {
        return new TokenTreeIterator(this.file.duplicate(), keyFetcher);
    }

    public OnDiskToken get(long searchToken, Function<Long, DecoratedKey> keyFetcher) {
        this.seekToLeaf(searchToken, this.file);
        long leafStart = this.file.position();
        short leafSize = this.file.getShort(leafStart + 1L);
        this.file.position(leafStart + 64L);
        short tokenIndex = this.searchLeaf(searchToken, leafSize);
        this.file.position(leafStart + 64L);
        OnDiskToken token = OnDiskToken.getTokenAt(this.file, tokenIndex, leafSize, keyFetcher);
        return token.get().equals(searchToken) ? token : null;
    }

    private boolean validateMagic() {
        switch (this.descriptor.version.toString()) {
            case "aa": {
                return true;
            }
            case "ab": {
                return 23121 == this.file.getShort();
            }
        }
        return false;
    }

    private void seekToLeaf(long token, MappedBuffer file) {
        long blockStart = this.startPos;
        while (true) {
            boolean isLeaf;
            file.position(blockStart);
            byte info = file.get();
            boolean bl = isLeaf = (info & 1) == 1;
            if (isLeaf) break;
            short tokenCount = file.getShort();
            long minToken = file.getLong();
            long maxToken = file.getLong();
            long seekBase = blockStart + 64L;
            if (minToken > token) {
                file.position(seekBase + (long)(tokenCount * 8));
                blockStart = this.startPos + (long)((int)file.getLong());
                continue;
            }
            if (maxToken < token) {
                file.position(seekBase + (long)(2 * tokenCount * 8));
                blockStart = this.startPos + (long)((int)file.getLong());
                continue;
            }
            file.position(seekBase);
            short offsetIndex = this.searchBlock(token, tokenCount, file);
            if (offsetIndex == tokenCount) {
                file.position(file.position() + (long)(offsetIndex * 8));
            } else {
                file.position(file.position() + (long)((tokenCount - offsetIndex - 1 + offsetIndex) * 8));
            }
            blockStart = this.startPos + (long)((int)file.getLong());
        }
        file.position(blockStart);
    }

    private short searchBlock(long searchToken, short tokenCount, MappedBuffer file) {
        long readToken;
        short offsetIndex = 0;
        for (int i = 0; i < tokenCount && searchToken >= (readToken = file.getLong()); ++i) {
            offsetIndex = (short)(offsetIndex + 1);
        }
        return offsetIndex;
    }

    private short searchLeaf(long searchToken, short tokenCount) {
        long token;
        long base = this.file.position();
        int start = 0;
        int end = tokenCount;
        int middle = 0;
        while (start <= end && (token = this.file.getLong(base + (long)((middle = start + (end - start >> 1)) * 16 + 4))) != searchToken) {
            if (token < searchToken) {
                start = middle + 1;
                continue;
            }
            end = middle - 1;
        }
        return (short)middle;
    }

    private static class KeyIterator
    extends AbstractGuavaIterator<DecoratedKey> {
        private final Function<Long, DecoratedKey> keyFetcher;
        private final long[] offsets;
        private int index = 0;

        public KeyIterator(Function<Long, DecoratedKey> keyFetcher, long[] offsets) {
            this.keyFetcher = keyFetcher;
            this.offsets = offsets;
        }

        @Override
        public DecoratedKey computeNext() {
            return this.index < this.offsets.length ? this.keyFetcher.apply(this.offsets[this.index++]) : (DecoratedKey)this.endOfData();
        }
    }

    private static class TokenInfo {
        private final MappedBuffer buffer;
        private final Function<Long, DecoratedKey> keyFetcher;
        private final long position;
        private final short leafSize;

        public TokenInfo(MappedBuffer buffer, long position, short leafSize, Function<Long, DecoratedKey> keyFetcher) {
            this.keyFetcher = keyFetcher;
            this.buffer = buffer;
            this.position = position;
            this.leafSize = leafSize;
        }

        public Iterator<DecoratedKey> iterator() {
            return new KeyIterator(this.keyFetcher, this.fetchOffsets());
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.keyFetcher).append(this.position).append(this.leafSize).build();
        }

        public boolean equals(Object other) {
            if (!(other instanceof TokenInfo)) {
                return false;
            }
            TokenInfo o = (TokenInfo)other;
            return this.keyFetcher == o.keyFetcher && this.position == o.position;
        }

        private long[] fetchOffsets() {
            short info = this.buffer.getShort(this.position);
            int offsetExtra = this.buffer.getShort(this.position + 2L) & 0xFFFF;
            int offsetData = this.buffer.getInt(this.position + 4L + 8L);
            TokenTreeBuilder.EntryType type = TokenTreeBuilder.EntryType.of(info & 3);
            switch (type) {
                case SIMPLE: {
                    return new long[]{offsetData};
                }
                case OVERFLOW: {
                    long[] offsets = new long[offsetExtra];
                    long offsetPos = this.buffer.position() + (long)(2 * (this.leafSize * 8)) + (long)(offsetData * 8);
                    for (int i = 0; i < offsetExtra; ++i) {
                        offsets[i] = this.buffer.getLong(offsetPos + (long)(i * 8));
                    }
                    return offsets;
                }
                case FACTORED: {
                    return new long[]{((long)offsetData << 16) + (long)offsetExtra};
                }
                case PACKED: {
                    return new long[]{offsetExtra, offsetData};
                }
            }
            throw new IllegalStateException("Unknown entry type: " + type);
        }
    }

    public static class OnDiskToken
    extends Token {
        private final Set<TokenInfo> info = new HashSet<TokenInfo>(2);
        private final Set<DecoratedKey> loadedKeys = new TreeSet<DecoratedKey>(DecoratedKey.comparator);

        public OnDiskToken(MappedBuffer buffer, long position, short leafSize, Function<Long, DecoratedKey> keyFetcher) {
            super(buffer.getLong(position + 4L));
            this.info.add(new TokenInfo(buffer, position, leafSize, keyFetcher));
        }

        @Override
        public void merge(CombinedValue<Long> other) {
            if (!(other instanceof Token)) {
                return;
            }
            Token o = (Token)other;
            if (this.token != o.token) {
                throw new IllegalArgumentException(String.format("%s != %s", this.token, o.token));
            }
            if (o instanceof OnDiskToken) {
                this.info.addAll(((OnDiskToken)other).info);
            } else {
                Iterators.addAll(this.loadedKeys, o.iterator());
            }
        }

        @Override
        public Iterator<DecoratedKey> iterator() {
            ArrayList<Iterator<DecoratedKey>> keys = new ArrayList<Iterator<DecoratedKey>>(this.info.size());
            for (TokenInfo i : this.info) {
                keys.add(i.iterator());
            }
            if (!this.loadedKeys.isEmpty()) {
                keys.add(this.loadedKeys.iterator());
            }
            return MergeIterator.get(keys, DecoratedKey.comparator, new MergeIterator.Reducer<DecoratedKey, DecoratedKey>(){
                DecoratedKey reduced = null;

                @Override
                public boolean trivialReduceIsTrivial() {
                    return true;
                }

                @Override
                public void reduce(int idx, DecoratedKey current) {
                    this.reduced = current;
                }

                @Override
                protected DecoratedKey getReduced() {
                    return this.reduced;
                }
            });
        }

        @Override
        public LongSet getOffsets() {
            LongHashSet offsets = new LongHashSet(4);
            for (TokenInfo i : this.info) {
                for (long offset : i.fetchOffsets()) {
                    offsets.add(offset);
                }
            }
            return offsets;
        }

        public static OnDiskToken getTokenAt(MappedBuffer buffer, int idx, short leafSize, Function<Long, DecoratedKey> keyFetcher) {
            return new OnDiskToken(buffer, OnDiskToken.getEntryPosition(idx, buffer), leafSize, keyFetcher);
        }

        private static long getEntryPosition(int idx, MappedBuffer file) {
            return file.position() + (long)(idx * 16);
        }
    }

    public class TokenTreeIterator
    extends RangeIterator<Long, Token> {
        private final Function<Long, DecoratedKey> keyFetcher;
        private final MappedBuffer file;
        private long currentLeafStart;
        private int currentTokenIndex;
        private long leafMinToken;
        private long leafMaxToken;
        private short leafSize;
        protected boolean firstIteration;
        private boolean lastLeaf;

        TokenTreeIterator(MappedBuffer file, Function<Long, DecoratedKey> keyFetcher) {
            super(TokenTree.this.treeMinToken, TokenTree.this.treeMaxToken, TokenTree.this.tokenCount);
            this.firstIteration = true;
            this.file = file;
            this.keyFetcher = keyFetcher;
        }

        @Override
        protected Token computeNext() {
            this.maybeFirstIteration();
            if (this.currentTokenIndex >= this.leafSize && this.lastLeaf) {
                return (Token)this.endOfData();
            }
            if (this.currentTokenIndex < this.leafSize) {
                return this.getTokenAt(this.currentTokenIndex++);
            }
            assert (!this.lastLeaf);
            this.seekToNextLeaf();
            this.setupBlock();
            return this.computeNext();
        }

        @Override
        protected void performSkipTo(Long nextToken) {
            this.maybeFirstIteration();
            if (nextToken <= this.leafMaxToken) {
                this.searchLeaf(nextToken);
            } else {
                TokenTree.this.seekToLeaf(nextToken, this.file);
                this.setupBlock();
                this.findNearest(nextToken);
            }
        }

        private void setupBlock() {
            this.currentLeafStart = this.file.position();
            this.currentTokenIndex = 0;
            this.lastLeaf = (this.file.get() & 2) > 0;
            this.leafSize = this.file.getShort();
            this.leafMinToken = this.file.getLong();
            this.leafMaxToken = this.file.getLong();
            this.file.position(this.currentLeafStart + 64L);
        }

        private void findNearest(Long next) {
            if (next > this.leafMaxToken && !this.lastLeaf) {
                this.seekToNextLeaf();
                this.setupBlock();
                this.findNearest(next);
            } else if (next > this.leafMinToken) {
                this.searchLeaf(next);
            }
        }

        private void searchLeaf(long next) {
            for (int i = this.currentTokenIndex; i < this.leafSize && this.compareTokenAt(this.currentTokenIndex, next) < 0; ++i) {
                ++this.currentTokenIndex;
            }
        }

        private int compareTokenAt(int idx, long toToken) {
            return Long.compare(this.file.getLong(this.getTokenPosition(idx)), toToken);
        }

        private Token getTokenAt(int idx) {
            return OnDiskToken.getTokenAt(this.file, idx, this.leafSize, this.keyFetcher);
        }

        private long getTokenPosition(int idx) {
            return OnDiskToken.getEntryPosition(idx, this.file) + 4L;
        }

        private void seekToNextLeaf() {
            this.file.position(this.currentLeafStart + 4096L);
        }

        @Override
        public void close() throws IOException {
        }

        private void maybeFirstIteration() {
            if (!this.firstIteration) {
                return;
            }
            TokenTree.this.seekToLeaf(TokenTree.this.treeMinToken, this.file);
            this.setupBlock();
            this.firstIteration = false;
        }
    }
}

