/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.postings;

import com.google.common.base.MoreObjects;
import org.apache.cassandra.index.sai.postings.OrdinalPostingList;

public class IntArrayPostingList
implements OrdinalPostingList {
    private final int[] postings;
    private int idx = 0;

    public IntArrayPostingList(int[] postings) {
        this.postings = postings;
    }

    @Override
    public long getOrdinal() {
        return this.idx;
    }

    @Override
    public long nextPosting() {
        if (this.idx >= this.postings.length) {
            return Long.MAX_VALUE;
        }
        return this.postings[this.idx++];
    }

    @Override
    public long size() {
        return this.postings.length;
    }

    @Override
    public long advance(long targetRowID) {
        for (int i = this.idx; i < this.postings.length; ++i) {
            int segmentRowId = this.getPostingAt(i);
            ++this.idx;
            if ((long)segmentRowId < targetRowID) continue;
            return segmentRowId;
        }
        return Long.MAX_VALUE;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("idx", this.idx).add("hashCode", Integer.toHexString(this.hashCode())).toString();
    }

    public int getPostingAt(int i) {
        return this.postings[i];
    }
}

