/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.tries;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.agrona.concurrent.UnsafeBuffer;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.db.tries.InMemoryReadTrie;
import org.apache.cassandra.db.tries.Trie;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.github.jamm.MemoryMeterStrategy;

public class InMemoryTrie<T>
extends InMemoryReadTrie<T> {
    @VisibleForTesting
    static final int ALLOCATED_SIZE_THRESHOLD;
    private int allocatedPos = 0;
    private int contentCount = 0;
    private final BufferType bufferType;
    private static final long EMPTY_SIZE_ON_HEAP;
    private static final long EMPTY_SIZE_OFF_HEAP;
    private static final long REFERENCE_ARRAY_ON_HEAP_SIZE;
    final ApplyState applyState = new ApplyState();

    public InMemoryTrie(BufferType bufferType) {
        super(new UnsafeBuffer[23], new AtomicReferenceArray[25], 0);
        this.bufferType = bufferType;
    }

    final void putInt(int pos, int value) {
        this.getChunk(pos).putInt(this.inChunkPointer(pos), value);
    }

    final void putIntVolatile(int pos, int value) {
        this.getChunk(pos).putIntVolatile(this.inChunkPointer(pos), value);
    }

    final void putShort(int pos, short value) {
        this.getChunk(pos).putShort(this.inChunkPointer(pos), value);
    }

    final void putShortVolatile(int pos, short value) {
        this.getChunk(pos).putShort(this.inChunkPointer(pos), value);
    }

    final void putByte(int pos, byte value) {
        this.getChunk(pos).putByte(this.inChunkPointer(pos), value);
    }

    private int allocateBlock() throws SpaceExhaustedException {
        int v = this.allocatedPos;
        if (this.inChunkPointer(v) == 0) {
            int leadBit = this.getChunkIdx(v, 8, 256);
            if (leadBit + 8 == 31) {
                throw new SpaceExhaustedException();
            }
            ByteBuffer newBuffer = this.bufferType.allocate(256 << leadBit);
            this.buffers[leadBit] = new UnsafeBuffer(newBuffer);
        }
        this.allocatedPos += 32;
        return v;
    }

    private int addContent(T value) {
        int index = this.contentCount++;
        int leadBit = this.getChunkIdx(index, 4, 16);
        int ofs = this.inChunkPointer(index, leadBit, 16);
        AtomicReferenceArray<T> array = this.contentArrays[leadBit];
        if (array == null) {
            assert (ofs == 0) : "Error in content arrays configuration.";
            this.contentArrays[leadBit] = array = new AtomicReferenceArray<T>(16 << leadBit);
        }
        array.lazySet(ofs, value);
        return index;
    }

    private void setContent(int index, T value) {
        int leadBit = this.getChunkIdx(index, 4, 16);
        int ofs = this.inChunkPointer(index, leadBit, 16);
        AtomicReferenceArray array = this.contentArrays[leadBit];
        array.set(ofs, value);
    }

    public void discardBuffers() {
        if (this.bufferType == BufferType.ON_HEAP) {
            return;
        }
        for (UnsafeBuffer b : this.buffers) {
            if (b == null) continue;
            FileUtils.clean(b.byteBuffer());
        }
    }

    private int attachChild(int node, int trans, int newChild) throws SpaceExhaustedException {
        assert (!this.isLeaf(node)) : "attachChild cannot be used on content nodes.";
        switch (this.offset(node)) {
            case 31: {
                assert (false) : "attachChild cannot be used on content nodes.";
            }
            case 30: {
                return this.attachChildToSparse(node, trans, newChild);
            }
            case 28: {
                this.attachChildToSplit(node, trans, newChild);
                return node;
            }
            case 27: {
                if (trans != this.getUnsignedByte(node)) break;
                this.putIntVolatile(node + 1, newChild);
                return node;
            }
        }
        return this.attachChildToChain(node, trans, newChild);
    }

    private void attachChildToSplit(int node, int trans, int newChild) throws SpaceExhaustedException {
        int midPos = this.splitBlockPointerAddress(node, this.splitNodeMidIndex(trans), 4);
        int mid = this.getInt(midPos);
        if (this.isNull(mid)) {
            mid = this.createEmptySplitNode();
            int tailPos = this.splitBlockPointerAddress(mid, this.splitNodeTailIndex(trans), 8);
            int tail = this.createEmptySplitNode();
            int childPos = this.splitBlockPointerAddress(tail, this.splitNodeChildIndex(trans), 8);
            this.putInt(childPos, newChild);
            this.putInt(tailPos, tail);
            this.putIntVolatile(midPos, mid);
            return;
        }
        int tailPos = this.splitBlockPointerAddress(mid, this.splitNodeTailIndex(trans), 8);
        int tail = this.getInt(tailPos);
        if (this.isNull(tail)) {
            tail = this.createEmptySplitNode();
            int childPos = this.splitBlockPointerAddress(tail, this.splitNodeChildIndex(trans), 8);
            this.putInt(childPos, newChild);
            this.putIntVolatile(tailPos, tail);
            return;
        }
        int childPos = this.splitBlockPointerAddress(tail, this.splitNodeChildIndex(trans), 8);
        this.putIntVolatile(childPos, newChild);
    }

    private int attachChildToSparse(int node, int trans, int newChild) throws SpaceExhaustedException {
        int index;
        int smallerCount = 0;
        for (index = 0; index < 6 && !this.isNull(this.getInt(node + -30 + index * 4)); ++index) {
            int existing = this.getUnsignedByte(node + -6 + index);
            if (existing == trans) {
                this.putIntVolatile(node + -30 + index * 4, newChild);
                return node;
            }
            if (existing >= trans) continue;
            ++smallerCount;
        }
        int childCount = index;
        if (childCount == 6) {
            int split = this.createEmptySplitNode();
            for (int i = 0; i < 6; ++i) {
                int t2 = this.getUnsignedByte(node + -6 + i);
                int p = this.getInt(node + -30 + i * 4);
                this.attachChildToSplitNonVolatile(split, t2, p);
            }
            this.attachChildToSplitNonVolatile(split, trans, newChild);
            return split;
        }
        this.putByte(node + -6 + childCount, (byte)trans);
        int order = this.getUnsignedShort(node + 0);
        int newOrder = InMemoryTrie.insertInOrderWord(order, childCount, smallerCount);
        this.putIntVolatile(node + -30 + childCount * 4, newChild);
        this.putShortVolatile(node + 0, (short)newOrder);
        return node;
    }

    private static int insertInOrderWord(int order, int newIndex, int smallerCount) {
        int r = 1;
        for (int i = 0; i < smallerCount; ++i) {
            r *= 6;
        }
        int head = order / r;
        int tail = order % r;
        return tail + (head * 6 + newIndex) * r;
    }

    private void attachChildToSplitNonVolatile(int node, int trans, int newChild) throws SpaceExhaustedException {
        assert (this.offset(node) == 28) : "Invalid split node in trie";
        int midPos = this.splitBlockPointerAddress(node, this.splitNodeMidIndex(trans), 4);
        int mid = this.getInt(midPos);
        if (this.isNull(mid)) {
            mid = this.createEmptySplitNode();
            this.putInt(midPos, mid);
        }
        assert (this.offset(mid) == 28) : "Invalid split node in trie";
        int tailPos = this.splitBlockPointerAddress(mid, this.splitNodeTailIndex(trans), 8);
        int tail = this.getInt(tailPos);
        if (this.isNull(tail)) {
            tail = this.createEmptySplitNode();
            this.putInt(tailPos, tail);
        }
        assert (this.offset(tail) == 28) : "Invalid split node in trie";
        int childPos = this.splitBlockPointerAddress(tail, this.splitNodeChildIndex(trans), 8);
        this.putInt(childPos, newChild);
    }

    private int attachChildToChain(int node, int transitionByte, int newChild) throws SpaceExhaustedException {
        int existingByte = this.getUnsignedByte(node);
        if (transitionByte == existingByte) {
            return this.expandOrCreateChainNode(transitionByte, newChild);
        }
        int existingChild = node + 1;
        if (this.offset(existingChild) == 28) {
            existingChild = this.getInt(existingChild);
        }
        return this.createSparseNode(existingByte, existingChild, transitionByte, newChild);
    }

    private boolean isExpandableChain(int newChild) {
        int newOffset = this.offset(newChild);
        return newChild > 0 && newChild - 1 > 0 && newOffset > 0 && newOffset <= 27;
    }

    private int createSparseNode(int byte1, int child1, int byte2, int child2) throws SpaceExhaustedException {
        assert (byte1 != byte2) : "Attempted to create a sparse node with two of the same transition";
        if (byte1 > byte2) {
            int t2 = byte1;
            byte1 = byte2;
            byte2 = t2;
            t2 = child1;
            child1 = child2;
            child2 = t2;
        }
        int node = this.allocateBlock() + 30;
        this.putByte(node + -6 + 0, (byte)byte1);
        this.putByte(node + -6 + 1, (byte)byte2);
        this.putInt(node + -30 + 0, child1);
        this.putInt(node + -30 + 4, child2);
        this.putShort(node + 0, (short)6);
        return node;
    }

    private int createNewChainNode(int transitionByte, int newChild) throws SpaceExhaustedException {
        int newNode = this.allocateBlock() + 28 - 1;
        this.putByte(newNode, (byte)transitionByte);
        this.putInt(newNode + 1, newChild);
        return newNode;
    }

    private int expandOrCreateChainNode(int transitionByte, int newChild) throws SpaceExhaustedException {
        if (this.isExpandableChain(newChild)) {
            int newNode = newChild - 1;
            this.putByte(newNode, (byte)transitionByte);
            return newNode;
        }
        return this.createNewChainNode(transitionByte, newChild);
    }

    private int createEmptySplitNode() throws SpaceExhaustedException {
        return this.allocateBlock() + 28;
    }

    private int createPrefixNode(int contentIndex, int child, boolean isSafeChain) throws SpaceExhaustedException {
        int node;
        assert (!this.isNullOrLeaf(child)) : "Prefix node cannot reference a childless node.";
        int offset = this.offset(child);
        if (offset == 28 || isSafeChain && offset > 4 && offset <= 27) {
            node = child & 0xFFFFFFE0 | 0x1F;
            this.putByte(node + -27, (byte)offset);
        } else {
            node = this.allocateBlock() + 31;
            this.putByte(node + -27, (byte)-1);
            this.putInt(node + -3, child);
        }
        this.putInt(node + -31, contentIndex);
        return node;
    }

    private int updatePrefixNodeChild(int node, int child) throws SpaceExhaustedException {
        assert (this.offset(node) == 31) : "updatePrefix called on non-prefix node";
        assert (!this.isNullOrLeaf(child)) : "Prefix node cannot reference a childless node.";
        if (!this.isEmbeddedPrefixNode(node)) {
            this.putIntVolatile(node + -3, child);
            return node;
        }
        int contentIndex = this.getInt(node + -31);
        return this.createPrefixNode(contentIndex, child, true);
    }

    private boolean isEmbeddedPrefixNode(int node) {
        return this.getUnsignedByte(node + -27) < 32;
    }

    private int preserveContent(int existingPreContentNode, int existingPostContentNode, int updatedPostContentNode) throws SpaceExhaustedException {
        if (existingPreContentNode == existingPostContentNode) {
            return updatedPostContentNode;
        }
        if (existingPostContentNode == updatedPostContentNode) {
            return existingPreContentNode;
        }
        if (this.isLeaf(existingPreContentNode)) {
            return this.createPrefixNode(~existingPreContentNode, updatedPostContentNode, true);
        }
        assert (this.offset(existingPreContentNode) == 31) : "Unexpected content in non-prefix and non-leaf node.";
        return this.updatePrefixNodeChild(existingPreContentNode, updatedPostContentNode);
    }

    public <U> void apply(Trie<U> mutation, UpsertTransformer<T, U> transformer) throws SpaceExhaustedException {
        int depth;
        Trie.Cursor<U> mutationCursor = mutation.cursor();
        assert (mutationCursor.depth() == 0) : "Unexpected non-fresh cursor.";
        ApplyState state = this.applyState;
        state.reset();
        state.descend(-1, mutationCursor.content(), transformer);
        assert (state.currentDepth == 0) : "Unexpected change to applyState. Concurrent trie modification?";
        while (true) {
            depth = mutationCursor.advance();
            while (state.currentDepth >= depth) {
                if (state.attachAndMoveToParentState()) continue;
                assert (depth == -1) : "Unexpected change to applyState. Concurrent trie modification?";
                return;
            }
            state.descend(mutationCursor.incomingTransition(), mutationCursor.content(), transformer);
            assert (state.currentDepth == depth) : "Unexpected change to applyState. Concurrent trie modification?";
        }
    }

    public <R> void putSingleton(ByteComparable key, R value, UpsertTransformer<T, ? super R> transformer) throws SpaceExhaustedException {
        this.apply(Trie.singleton(key, value), transformer);
    }

    public <R> void putSingleton(ByteComparable key, R value, UpsertTransformer<T, ? super R> transformer, boolean useRecursive) throws SpaceExhaustedException {
        if (useRecursive) {
            this.putRecursive(key, value, transformer);
        } else {
            this.putSingleton(key, value, transformer);
        }
    }

    public <R> void putRecursive(ByteComparable key, R value, UpsertTransformer<T, R> transformer) throws SpaceExhaustedException {
        int newRoot = this.putRecursive(this.root, key.asComparableBytes(BYTE_COMPARABLE_VERSION), value, transformer);
        if (newRoot != this.root) {
            this.root = newRoot;
        }
    }

    private <R> int putRecursive(int node, ByteSource key, R value, UpsertTransformer<T, R> transformer) throws SpaceExhaustedException {
        int transition = key.next();
        if (transition == -1) {
            return this.applyContent(node, value, transformer);
        }
        int child = this.getChild(node, transition);
        int newChild = this.putRecursive(child, key, value, transformer);
        if (newChild == child) {
            return node;
        }
        int skippedContent = this.followContentTransition(node);
        int attachedChild = !this.isNull(skippedContent) ? this.attachChild(skippedContent, transition, newChild) : this.expandOrCreateChainNode(transition, newChild);
        return this.preserveContent(node, skippedContent, attachedChild);
    }

    private <R> int applyContent(int node, R value, UpsertTransformer<T, R> transformer) throws SpaceExhaustedException {
        if (this.isNull(node)) {
            return ~this.addContent(transformer.apply(null, value));
        }
        if (this.isLeaf(node)) {
            int contentIndex = ~node;
            this.setContent(contentIndex, transformer.apply(this.getContent(contentIndex), value));
            return node;
        }
        if (this.offset(node) == 31) {
            int contentIndex = this.getInt(node + -31);
            this.setContent(contentIndex, transformer.apply(this.getContent(contentIndex), value));
            return node;
        }
        return this.createPrefixNode(this.addContent(transformer.apply(null, value)), node, false);
    }

    public boolean reachedAllocatedSizeThreshold() {
        return this.allocatedPos >= ALLOCATED_SIZE_THRESHOLD;
    }

    @VisibleForTesting
    int advanceAllocatedPos(int wantedPos) throws SpaceExhaustedException {
        while (this.allocatedPos < wantedPos) {
            this.allocateBlock();
        }
        return this.allocatedPos;
    }

    public long sizeOffHeap() {
        return this.bufferType == BufferType.ON_HEAP ? 0L : (long)this.allocatedPos;
    }

    public long sizeOnHeap() {
        return (long)(this.contentCount * MemoryMeterStrategy.MEMORY_LAYOUT.getReferenceSize()) + REFERENCE_ARRAY_ON_HEAP_SIZE * (long)this.getChunkIdx(this.contentCount, 4, 16) + (this.bufferType == BufferType.ON_HEAP ? (long)this.allocatedPos + EMPTY_SIZE_ON_HEAP : EMPTY_SIZE_OFF_HEAP) + REFERENCE_ARRAY_ON_HEAP_SIZE * (long)this.getChunkIdx(this.allocatedPos, 8, 256);
    }

    @Override
    public Iterable<T> valuesUnordered() {
        return () -> new Iterator<T>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < InMemoryTrie.this.contentCount;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return InMemoryTrie.this.getContent(this.idx++);
            }
        };
    }

    public int valuesCount() {
        return this.contentCount;
    }

    public long unusedReservedMemory() {
        int pos;
        UnsafeBuffer buffer;
        int bufferOverhead = 0;
        if (this.bufferType == BufferType.ON_HEAP && (buffer = this.getChunk(pos = this.allocatedPos)) != null) {
            bufferOverhead = buffer.capacity() - this.inChunkPointer(pos);
        }
        int index = this.contentCount;
        int leadBit = this.getChunkIdx(index, 4, 16);
        int ofs = this.inChunkPointer(index, leadBit, 16);
        AtomicReferenceArray contentArray = this.contentArrays[leadBit];
        int contentOverhead = ((contentArray != null ? contentArray.length() : 0) - ofs) * MemoryMeterStrategy.MEMORY_LAYOUT.getReferenceSize();
        return bufferOverhead + contentOverhead;
    }

    static {
        int limitInMB = CassandraRelevantProperties.MEMTABLE_OVERHEAD_SIZE.getInt(1861);
        if (limitInMB < 1 || limitInMB > 2047) {
            throw new AssertionError((Object)(CassandraRelevantProperties.MEMTABLE_OVERHEAD_SIZE.getKey() + " must be within 1 and 2047"));
        }
        ALLOCATED_SIZE_THRESHOLD = 0x100000 * limitInMB;
        REFERENCE_ARRAY_ON_HEAP_SIZE = ObjectSizes.measureDeep(new AtomicReferenceArray(0));
        InMemoryTrie empty = new InMemoryTrie(BufferType.ON_HEAP);
        EMPTY_SIZE_ON_HEAP = ObjectSizes.measureDeep(empty);
        empty = new InMemoryTrie(BufferType.OFF_HEAP);
        EMPTY_SIZE_OFF_HEAP = ObjectSizes.measureDeep(empty);
    }

    public static interface UpsertTransformer<T, U> {
        public T apply(T var1, U var2);
    }

    class ApplyState {
        int[] data = new int[80];
        int currentDepth = -1;

        ApplyState() {
        }

        void reset() {
            this.currentDepth = -1;
        }

        int existingPreContentNode() {
            return this.data[this.currentDepth * 5 + 0];
        }

        void setExistingPreContentNode(int value) {
            this.data[this.currentDepth * 5 + 0] = value;
        }

        int existingPostContentNode() {
            return this.data[this.currentDepth * 5 + 1];
        }

        void setExistingPostContentNode(int value) {
            this.data[this.currentDepth * 5 + 1] = value;
        }

        int updatedPostContentNode() {
            return this.data[this.currentDepth * 5 + 2];
        }

        void setUpdatedPostContentNode(int value) {
            this.data[this.currentDepth * 5 + 2] = value;
        }

        int transition() {
            return this.data[this.currentDepth * 5 + 3];
        }

        void setTransition(int transition) {
            this.data[this.currentDepth * 5 + 3] = transition;
        }

        int contentIndex() {
            return this.data[this.currentDepth * 5 + 4];
        }

        void setContentIndex(int value) {
            this.data[this.currentDepth * 5 + 4] = value;
        }

        <U> void descend(int transition, U mutationContent, UpsertTransformer<T, U> transformer) {
            int existingPostContentNode;
            int existingPreContentNode;
            if (this.currentDepth < 0) {
                existingPreContentNode = InMemoryTrie.this.root;
            } else {
                this.setTransition(transition);
                existingPreContentNode = InMemoryTrie.this.isNull(this.existingPostContentNode()) ? 0 : InMemoryTrie.this.getChild(this.existingPostContentNode(), transition);
            }
            ++this.currentDepth;
            if (this.currentDepth * 5 >= this.data.length) {
                this.data = Arrays.copyOf(this.data, this.currentDepth * 5 * 2);
            }
            this.setExistingPreContentNode(existingPreContentNode);
            int existingContentIndex = -1;
            if (InMemoryTrie.this.isLeaf(existingPreContentNode)) {
                existingContentIndex = ~existingPreContentNode;
                existingPostContentNode = 0;
            } else if (InMemoryTrie.this.offset(existingPreContentNode) == 31) {
                existingContentIndex = InMemoryTrie.this.getInt(existingPreContentNode + -31);
                existingPostContentNode = InMemoryTrie.this.followContentTransition(existingPreContentNode);
            } else {
                existingPostContentNode = existingPreContentNode;
            }
            this.setExistingPostContentNode(existingPostContentNode);
            this.setUpdatedPostContentNode(existingPostContentNode);
            int contentIndex = this.updateContentIndex(mutationContent, existingContentIndex, transformer);
            this.setContentIndex(contentIndex);
        }

        private <U> int updateContentIndex(U mutationContent, int existingContentIndex, UpsertTransformer<T, U> transformer) {
            if (mutationContent != null) {
                if (existingContentIndex != -1) {
                    Object existingContent = InMemoryTrie.this.getContent(existingContentIndex);
                    Object combinedContent = transformer.apply(existingContent, mutationContent);
                    assert (combinedContent != null) : "Transformer cannot be used to remove content.";
                    InMemoryTrie.this.setContent(existingContentIndex, combinedContent);
                    return existingContentIndex;
                }
                Object combinedContent = transformer.apply(null, mutationContent);
                assert (combinedContent != null) : "Transformer cannot be used to remove content.";
                return InMemoryTrie.this.addContent(combinedContent);
            }
            return existingContentIndex;
        }

        private void attachChild(int transition, int child) throws SpaceExhaustedException {
            int updatedPostContentNode = this.updatedPostContentNode();
            if (InMemoryTrie.this.isNull(updatedPostContentNode)) {
                this.setUpdatedPostContentNode(InMemoryTrie.this.expandOrCreateChainNode(transition, child));
            } else {
                this.setUpdatedPostContentNode(InMemoryTrie.this.attachChild(updatedPostContentNode, transition, child));
            }
        }

        private int applyContent() throws SpaceExhaustedException {
            int existingPostContentNode;
            int contentIndex = this.contentIndex();
            int updatedPostContentNode = this.updatedPostContentNode();
            if (contentIndex == -1) {
                return updatedPostContentNode;
            }
            if (InMemoryTrie.this.isNull(updatedPostContentNode)) {
                return ~contentIndex;
            }
            int existingPreContentNode = this.existingPreContentNode();
            if (existingPreContentNode == (existingPostContentNode = this.existingPostContentNode()) || InMemoryTrie.this.isNull(existingPostContentNode) || InMemoryTrie.this.isEmbeddedPrefixNode(existingPreContentNode) && updatedPostContentNode != existingPostContentNode) {
                return InMemoryTrie.this.createPrefixNode(contentIndex, updatedPostContentNode, InMemoryTrie.this.isNull(existingPostContentNode));
            }
            if (updatedPostContentNode != existingPostContentNode) {
                InMemoryTrie.this.putIntVolatile(existingPreContentNode + -3, updatedPostContentNode);
            }
            assert (contentIndex == InMemoryTrie.this.getInt(existingPreContentNode + -31)) : "Unexpected change of content index.";
            return existingPreContentNode;
        }

        private boolean attachAndMoveToParentState() throws SpaceExhaustedException {
            int updatedPreContentNode = this.applyContent();
            int existingPreContentNode = this.existingPreContentNode();
            --this.currentDepth;
            if (this.currentDepth == -1) {
                assert (InMemoryTrie.this.root == existingPreContentNode) : "Unexpected change to root. Concurrent trie modification?";
                if (updatedPreContentNode != existingPreContentNode) {
                    InMemoryTrie.this.root = updatedPreContentNode;
                }
                return false;
            }
            if (updatedPreContentNode != existingPreContentNode) {
                this.attachChild(this.transition(), updatedPreContentNode);
            }
            return true;
        }
    }

    public static class SpaceExhaustedException
    extends Exception {
        public SpaceExhaustedException() {
            super("The hard 2GB limit on trie size has been exceeded");
        }
    }
}

