/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoubleSupplier;
import org.apache.cassandra.db.streaming.CompressionInfo;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RebufferingInputStream;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.utils.ChecksumType;

public class CompressedInputStream
extends RebufferingInputStream
implements AutoCloseable {
    private static final double GROWTH_FACTOR = 1.5;
    private final DataInputPlus input;
    private final Iterator<CompressionMetadata.Chunk> compressedChunks;
    private final CompressionParams compressionParams;
    private final ChecksumType checksumType;
    private final DoubleSupplier validateChecksumChance;
    private long uncompressedChunkPosition = Long.MIN_VALUE;
    private ByteBuffer compressedChunk;
    private byte[] copyArray;
    private long chunkBytesRead = 0L;

    public CompressedInputStream(DataInputPlus input, CompressionInfo compressionInfo, ChecksumType checksumType, DoubleSupplier validateChecksumChance) {
        super(ByteBuffer.allocateDirect(compressionInfo.parameters().chunkLength()));
        this.buffer.limit(0);
        this.input = input;
        this.checksumType = checksumType;
        this.validateChecksumChance = validateChecksumChance;
        this.compressionParams = compressionInfo.parameters();
        this.compressedChunks = Iterators.forArray(compressionInfo.chunks());
        this.compressedChunk = ByteBuffer.allocateDirect(this.compressionParams.chunkLength());
    }

    public void position(long position) throws IOException {
        if (position < this.uncompressedChunkPosition + (long)this.buffer.position()) {
            throw new IllegalStateException("stream can only move forward");
        }
        if (position >= this.uncompressedChunkPosition + (long)this.buffer.limit()) {
            this.loadNextChunk();
            this.uncompressedChunkPosition = position & (long)(-this.compressionParams.chunkLength());
        }
        this.buffer.position(Ints.checkedCast(position - this.uncompressedChunkPosition));
    }

    @Override
    protected void reBuffer() throws IOException {
        if (this.uncompressedChunkPosition < 0L) {
            throw new IllegalStateException("position(long position) wasn't called first");
        }
        this.loadNextChunk();
        this.uncompressedChunkPosition += (long)this.compressionParams.chunkLength();
    }

    private void loadNextChunk() throws IOException {
        if (!this.compressedChunks.hasNext()) {
            throw new EOFException();
        }
        int chunkLength = this.compressedChunks.next().length;
        this.chunkBytesRead += (long)(chunkLength + 4);
        if (chunkLength < this.compressionParams.maxCompressedLength()) {
            if (this.compressedChunk.capacity() < chunkLength) {
                FileUtils.clean(this.compressedChunk);
                this.compressedChunk = ByteBuffer.allocateDirect(Math.max((int)((double)this.compressedChunk.capacity() * 1.5), chunkLength));
            }
            this.compressedChunk.position(0).limit(chunkLength);
            this.readChunk(this.compressedChunk);
            this.compressedChunk.position(0);
            this.maybeValidateChecksum(this.compressedChunk, this.input.readInt());
            this.buffer.clear();
            this.compressionParams.getSstableCompressor().uncompress(this.compressedChunk, this.buffer);
            this.buffer.flip();
        } else {
            this.buffer.position(0).limit(chunkLength);
            this.readChunk(this.buffer);
            this.buffer.position(0);
            this.maybeValidateChecksum(this.buffer, this.input.readInt());
        }
    }

    private void readChunk(ByteBuffer dst) throws IOException {
        if (this.input instanceof RebufferingInputStream) {
            ((RebufferingInputStream)this.input).readFully(dst);
        } else {
            this.readChunkSlow(dst);
        }
    }

    private void readChunkSlow(ByteBuffer dst) throws IOException {
        if (this.copyArray == null) {
            this.copyArray = new byte[dst.remaining()];
        } else if (this.copyArray.length < dst.remaining()) {
            this.copyArray = new byte[Math.max((int)((double)this.copyArray.length * 1.5), dst.remaining())];
        }
        this.input.readFully(this.copyArray, 0, dst.remaining());
        dst.put(this.copyArray, 0, dst.remaining());
    }

    private void maybeValidateChecksum(ByteBuffer buffer, int expectedChecksum) throws IOException {
        double validateChance = this.validateChecksumChance.getAsDouble();
        if (validateChance >= 1.0 || validateChance > 0.0 && validateChance > ThreadLocalRandom.current().nextDouble()) {
            int position = buffer.position();
            int actualChecksum = (int)this.checksumType.of(buffer);
            buffer.position(position);
            if (expectedChecksum != actualChecksum) {
                throw new IOException(String.format("Checksum didn't match (expected: %d, actual: %d)", expectedChecksum, actualChecksum));
            }
        }
    }

    @Override
    public void close() {
        if (null != this.buffer) {
            FileUtils.clean(this.buffer);
            this.buffer = null;
        }
        if (null != this.compressedChunk) {
            FileUtils.clean(this.compressedChunk);
            this.compressedChunk = null;
        }
    }

    long chunkBytesRead() {
        return this.chunkBytesRead;
    }
}

