/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.AbstractOnHeapClusteringPrefix;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractBufferClusteringPrefix
extends AbstractOnHeapClusteringPrefix<ByteBuffer> {
    public static final ByteBuffer[] EMPTY_VALUES_ARRAY = new ByteBuffer[0];

    protected AbstractBufferClusteringPrefix(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
        super(kind, values);
    }

    @Override
    public ValueAccessor<ByteBuffer> accessor() {
        return ByteBufferAccessor.instance;
    }

    @Override
    public ByteBuffer[] getBufferArray() {
        return (ByteBuffer[])this.getRawValues();
    }

    @Override
    public ClusteringPrefix<ByteBuffer> retainable() {
        if (!ByteBufferUtil.canMinimize((ByteBuffer[])this.values)) {
            return this;
        }
        ByteBuffer[] minimizedValues = ByteBufferUtil.minimizeBuffers((ByteBuffer[])this.values);
        if (this.kind.isBoundary()) {
            return this.accessor().factory().boundary(this.kind, (ByteBuffer[])minimizedValues);
        }
        if (this.kind.isBound()) {
            return this.accessor().factory().bound(this.kind, (ByteBuffer[])minimizedValues);
        }
        assert (this.kind() != ClusteringPrefix.Kind.STATIC_CLUSTERING);
        return this.accessor().factory().clustering((ByteBuffer[])minimizedValues);
    }
}

