/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Set;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.RoleName;
import org.apache.cassandra.cql3.statements.AuthorizationStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class PermissionsManagementStatement
extends AuthorizationStatement {
    protected final Set<Permission> permissions;
    protected IResource resource;
    protected final RoleResource grantee;

    protected PermissionsManagementStatement(Set<Permission> permissions, IResource resource, RoleName grantee) {
        this.permissions = permissions;
        this.resource = resource;
        this.grantee = RoleResource.role(grantee.getName());
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        state.ensureNotAnonymous();
        if (!DatabaseDescriptor.getRoleManager().isExistingRole(this.grantee)) {
            throw new InvalidRequestException(String.format("Role %s doesn't exist", this.grantee.getRoleName()));
        }
        this.resource = PermissionsManagementStatement.maybeCorrectResource(this.resource, state);
        if (!this.resource.exists()) {
            throw new InvalidRequestException(String.format("Resource %s doesn't exist", this.resource));
        }
    }

    @Override
    public void authorize(ClientState state) throws UnauthorizedException {
        this.resource = PermissionsManagementStatement.maybeCorrectResource(this.resource, state);
        state.ensurePermission(Permission.AUTHORIZE, this.resource);
        for (Permission p : this.permissions) {
            state.ensurePermission(p, this.resource);
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

