/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client.request;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.mockwebserver.MockWebServer;
import org.apache.cassandra.sidecar.client.HttpClient;
import org.apache.cassandra.sidecar.client.HttpClientConfig;
import org.apache.cassandra.sidecar.client.RequestContext;
import org.apache.cassandra.sidecar.client.RequestExecutor;
import org.apache.cassandra.sidecar.client.SidecarInstanceImpl;
import org.apache.cassandra.sidecar.client.SidecarInstancesProvider;
import org.apache.cassandra.sidecar.client.SimpleSidecarInstancesProvider;
import org.apache.cassandra.sidecar.client.retry.NoRetryPolicy;
import org.apache.cassandra.sidecar.client.retry.RetryPolicy;
import org.apache.cassandra.sidecar.client.selection.InstanceSelectionPolicy;
import org.apache.cassandra.sidecar.client.selection.OrderedInstanceSelectionPolicy;
import org.apache.cassandra.sidecar.client.selection.RandomInstanceSelectionPolicy;
import org.jetbrains.annotations.NotNull;

public abstract class BaseRequestTest {
    protected abstract RequestExecutor sidecarClient();

    protected abstract HttpClient httpClient();

    protected abstract HttpClientConfig httpClientConfig();

    protected RetryPolicy retryPolicy() {
        return new NoRetryPolicy();
    }

    protected RequestContext.Builder builder(InstanceSelectionPolicy instanceSelectionPolicy) {
        return this.newBuilder().instanceSelectionPolicy(instanceSelectionPolicy).retryPolicy(this.retryPolicy());
    }

    protected RequestContext.Builder newBuilder() {
        return new RequestContext.Builder();
    }

    public static InstanceSelectionPolicy buildRandomFromServerList(MockWebServer ... servers) {
        List instances = Arrays.stream(servers).map(BaseRequestTest::newSidecarInstance).collect(Collectors.toList());
        return new RandomInstanceSelectionPolicy((SidecarInstancesProvider)new SimpleSidecarInstancesProvider(instances));
    }

    public static InstanceSelectionPolicy buildFromServerList(MockWebServer ... servers) {
        List instances = Arrays.stream(servers).map(BaseRequestTest::newSidecarInstance).collect(Collectors.toList());
        return new OrderedInstanceSelectionPolicy((SidecarInstancesProvider)new SimpleSidecarInstancesProvider(instances));
    }

    @NotNull
    public static SidecarInstanceImpl newSidecarInstance(MockWebServer server) {
        return new SidecarInstanceImpl(server.getHostName(), server.getPort());
    }
}

