/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.util;

import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NotNull;

public final class ThreadUtil {
    private ThreadUtil() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    @NotNull
    public static ThreadFactory threadFactory(@NotNull String threadName) {
        return ThreadUtil.threadFactory(threadName, true);
    }

    @NotNull
    public static ThreadFactory threadFactory(@NotNull String threadName, boolean isDaemon) {
        return runnable -> ThreadUtil.newThread(runnable, threadName, isDaemon);
    }

    @NotNull
    private static Thread newThread(@NotNull Runnable runnable, @NotNull String threadName, boolean isDaemon) {
        Thread thread = new Thread(runnable, threadName);
        thread.setDaemon(isDaemon);
        return thread;
    }
}

