/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThrowableUtils {
    private ThrowableUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    @NotNull
    public static Throwable rootCause(@NotNull Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    @Nullable
    public static <T extends Throwable> T rootCause(@NotNull Throwable throwable, @NotNull Class<T> ofType) {
        while (throwable.getCause() != null) {
            if (ofType.isInstance(throwable)) {
                return (T)((Throwable)ofType.cast(throwable));
            }
            throwable = throwable.getCause();
        }
        return (T)(ofType.isInstance(throwable) ? (Throwable)ofType.cast(throwable) : null);
    }
}

