/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql.filters;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.jetbrains.annotations.NotNull;

public final class PartitionKeyFilter
implements Serializable,
Comparable<PartitionKeyFilter> {
    @NotNull
    private BigInteger token;
    @NotNull
    private ByteBuffer filterKey;

    public PartitionKeyFilter(@NotNull ByteBuffer filterKey, @NotNull BigInteger filterKeyTokenValue) {
        this.filterKey = filterKey.duplicate();
        this.token = filterKeyTokenValue;
    }

    @NotNull
    public TokenRange tokenRange() {
        return TokenRange.singleton(this.token);
    }

    @NotNull
    public ByteBuffer key() {
        return this.filterKey;
    }

    @NotNull
    public BigInteger token() {
        return this.token;
    }

    public boolean overlaps(@NotNull TokenRange tokenRange) {
        return tokenRange.contains(this.token);
    }

    public boolean matches(@NotNull ByteBuffer key) {
        return key.compareTo(this.key()) == 0;
    }

    public boolean filter(@NotNull ByteBuffer key) {
        return this.key().compareTo(key) == 0;
    }

    @NotNull
    public static PartitionKeyFilter create(@NotNull ByteBuffer filterKey, @NotNull BigInteger filterKeyTokenValue) {
        Preconditions.checkArgument((filterKey.capacity() != 0 ? 1 : 0) != 0);
        return new PartitionKeyFilter(filterKey, filterKeyTokenValue);
    }

    private void readObject(ObjectInputStream input) throws IOException {
        int keyLength = input.readInt();
        byte[] keyArray = new byte[keyLength];
        ByteBufferUtils.readFully(input, keyArray, keyLength);
        this.filterKey = ByteBuffer.wrap(keyArray);
        byte tokenLength = input.readByte();
        byte[] tokenArray = new byte[tokenLength];
        ByteBufferUtils.readFully(input, tokenArray, tokenLength);
        this.token = new BigInteger(tokenArray);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        ByteBuffer key = this.filterKey.duplicate();
        byte[] keyArray = new byte[key.remaining()];
        key.get(keyArray);
        output.writeInt(keyArray.length);
        output.write(keyArray);
        byte[] tokenArray = this.token.toByteArray();
        if (tokenArray.length == 0 || tokenArray.length >= 128) {
            throw new IllegalStateException("Invalid token length: " + tokenArray.length);
        }
        output.writeByte(tokenArray.length);
        output.write(tokenArray);
    }

    public int hashCode() {
        return Objects.hash(this.filterKey, this.token);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PartitionKeyFilter that = (PartitionKeyFilter)other;
        return this.filterKey.equals(that.filterKey) && this.token.equals(that.token);
    }

    @Override
    public int compareTo(@NotNull PartitionKeyFilter other) {
        int compare = this.token.compareTo(other.token);
        if (compare == 0) {
            return this.key().compareTo(other.key());
        }
        return compare;
    }
}

