/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.secrets;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface SecretsProvider {
    public void initialize(@NotNull Map<String, String> var1);

    public boolean hasKeyStoreSecrets();

    public InputStream keyStoreInputStream() throws IOException;

    public char[] keyStorePassword();

    default public String keyStoreType() {
        return "PKCS12";
    }

    public boolean hasTrustStoreSecrets();

    public InputStream trustStoreInputStream() throws IOException;

    public char[] trustStorePassword();

    default public String trustStoreType() {
        return "JKS";
    }

    public void validateMutualTLS();

    public String secretByName(String var1);

    public Path secretsPath();
}

