/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.msg;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cdc.msg.Value;
import org.jetbrains.annotations.NotNull;

public class RangeTombstone {
    protected static final String RANGE_START = "Start";
    protected static final String RANGE_START_INCL = "StartInclusive";
    protected static final String RANGE_END = "End";
    protected static final String RANGE_END_INCL = "EndInclusive";
    final List<Value> startBound;
    public final boolean startInclusive;
    final List<Value> endBound;
    public final boolean endInclusive;

    public RangeTombstone() {
        this.startInclusive = false;
        this.startBound = null;
        this.endInclusive = false;
        this.endBound = null;
    }

    public RangeTombstone(@NotNull List<Value> startBound, boolean startInclusive, @NotNull List<Value> endBound, boolean endInclusive) {
        this.startBound = new ArrayList<Value>(startBound);
        this.startInclusive = startInclusive;
        this.endBound = new ArrayList<Value>(endBound);
        this.endInclusive = endInclusive;
    }

    public List<Value> getStartBound() {
        return this.startBound;
    }

    public List<Value> getEndBound() {
        return this.endBound;
    }
}

