/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RebufferingInputStream;

public class RebufferingChannelInputStream
extends RebufferingInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private final ReadableByteChannel channel;

    public RebufferingChannelInputStream(InputStream inputStream) {
        this(inputStream, 16384);
    }

    public RebufferingChannelInputStream(InputStream inputStream, int bufferSize) {
        super(ByteBuffer.allocate(bufferSize <= 0 ? 16384 : bufferSize));
        this.channel = Channels.newChannel(inputStream);
        this.buffer.limit(0);
    }

    protected void reBuffer() throws IOException {
        this.buffer.clear();
        this.channel.read(this.buffer);
        this.buffer.flip();
    }

    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            try {
                FileUtils.clean((ByteBuffer)this.buffer);
            }
            finally {
                this.channel.close();
            }
        }
    }
}

