/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.apache.cassandra.spark.bulkwriter.AbstractBulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.BulkWriterConfig;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.DataTransport;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CassandraClusterInfoGroup;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterContainer;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.types.StructType;
import org.jetbrains.annotations.NotNull;

public class CassandraCoordinatedBulkWriterContext
extends AbstractBulkWriterContext {
    public CassandraCoordinatedBulkWriterContext(@NotNull BulkSparkConf conf, @NotNull StructType structType, int sparkDefaultParallelism) {
        super(conf, structType, sparkDefaultParallelism);
        this.validateConfiguration(conf);
    }

    public CassandraCoordinatedBulkWriterContext(@NotNull BulkWriterConfig config) {
        super(config);
        this.validateConfiguration(config.getConf());
    }

    private void validateConfiguration(BulkSparkConf conf) {
        Preconditions.checkArgument((boolean)conf.isCoordinatedWriteConfigured(), (Object)"Cannot create CassandraCoordinatedBulkWriterContext without CoordinatedWrite configuration");
        Preconditions.checkArgument((conf.getTransportInfo().getTransport() == DataTransport.S3_COMPAT ? 1 : 0) != 0, (Object)("CassandraCoordinatedBulkWriterContext can only be created with " + String.valueOf(DataTransport.S3_COMPAT)));
    }

    @Override
    protected ClusterInfo buildClusterInfo() {
        CassandraClusterInfoGroup clusterInfoGroup = CassandraClusterInfoGroup.fromBulkSparkConf(this.bulkSparkConf());
        clusterInfoGroup.startupValidate();
        return clusterInfoGroup;
    }

    @Override
    protected void validateKeyspaceReplication() {
        BulkSparkConf conf = this.bulkSparkConf();
        if (!conf.consistencyLevel.isLocal()) {
            return;
        }
        CoordinatedWriteConf coordinatedWriteConf = conf.coordinatedWriteConf();
        coordinatedWriteConf.clusters().forEach((clusterId, clusterConf) -> {
            String localDc = clusterConf.localDc();
            ClusterInfo cluster = this.clusterInfoGroup().getValueOrNull((String)clusterId);
            boolean isReplicatedToLocalDc = !StringUtils.isEmpty((CharSequence)localDc) && cluster != null && cluster.replicationFactor().getOptions().containsKey(localDc);
            Preconditions.checkState((boolean)isReplicatedToLocalDc, (String)"Keyspace %s is not replicated on datacenter %s in %s", (Object[])new Object[]{conf.keyspace, localDc, clusterId});
        });
    }

    @Override
    protected MultiClusterContainer<UUID> generateRestoreJobIds() {
        MultiClusterContainer<UUID> result = new MultiClusterContainer<UUID>();
        this.clusterInfoGroup().forEach((clusterId, ignored) -> result.setValue((String)clusterId, this.bridge().getTimeUUID()));
        return result;
    }

    protected CassandraClusterInfoGroup clusterInfoGroup() {
        return (CassandraClusterInfoGroup)this.cluster();
    }
}

