/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.SortedSSTableWriter;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApiFactory;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageStreamSession;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.StorageClient;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedCloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportConfiguration;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraCloudStorageTransportContext
implements TransportContext.CloudStorageTransportContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraCloudStorageTransportContext.class);
    @NotNull
    private final StorageTransportExtension storageTransportExtension;
    @NotNull
    private final StorageTransportConfiguration storageTransportConfiguration;
    @NotNull
    private final CloudStorageDataTransferApi dataTransferApi;
    @NotNull
    private final BulkSparkConf conf;
    @NotNull
    private final JobInfo jobInfo;
    @NotNull
    private final ClusterInfo clusterInfo;
    @NotNull
    private final StorageClient storageClient;

    public CassandraCloudStorageTransportContext(@NotNull BulkWriterContext bulkWriterContext, @NotNull BulkSparkConf conf, boolean isOnDriver) {
        Objects.requireNonNull(conf.getTransportInfo().getTransportExtensionClass(), "DATA_TRANSPORT_EXTENSION_CLASS must be provided");
        this.conf = conf;
        this.jobInfo = bulkWriterContext.job();
        this.clusterInfo = bulkWriterContext.cluster();
        this.storageTransportExtension = this.createStorageTransportExtension(isOnDriver);
        this.storageTransportConfiguration = this.storageTransportExtension.getStorageConfiguration();
        Objects.requireNonNull(this.storageTransportConfiguration, "Storage configuration cannot be null in order to upload to cloud");
        this.storageClient = new StorageClient(this.storageTransportConfiguration, conf.getStorageClientConfig());
        this.dataTransferApi = this.createDataTransferApi(this.storageClient);
        Preconditions.checkState((!this.jobInfo.isCoordinatedWriteEnabled() || this.dataTransferApi instanceof CoordinatedCloudStorageDataTransferApi ? 1 : 0) != 0, (Object)"CoordinatedCloudStorageDataTransferApi must be created when coordinated write is enabled");
    }

    public CloudStorageStreamSession createStreamSession(BulkWriterContext writerContext, String sessionId, SortedSSTableWriter sstableWriter, Range<BigInteger> range, ReplicaAwareFailureHandler<RingInstance> failureHandler, ExecutorService executorService) {
        return new CloudStorageStreamSession(writerContext, sstableWriter, this, sessionId, range, failureHandler, executorService);
    }

    @Override
    public CloudStorageDataTransferApi dataTransferApi() {
        return this.dataTransferApi;
    }

    @Override
    @NotNull
    public StorageTransportConfiguration transportConfiguration() {
        return this.storageTransportConfiguration;
    }

    @Override
    @NotNull
    public StorageTransportExtension transportExtensionImplementation() {
        return this.storageTransportExtension;
    }

    protected CloudStorageDataTransferApi createDataTransferApi(StorageClient storageClient) {
        return CloudStorageDataTransferApiFactory.INSTANCE.createDataTransferApi(storageClient, this.jobInfo, this.clusterInfo);
    }

    protected StorageTransportExtension createStorageTransportExtension(boolean isOnDriver) {
        String transportExtensionClass = this.conf.getTransportInfo().getTransportExtensionClass();
        try {
            Class<?> clazz = Class.forName(transportExtensionClass);
            StorageTransportExtension extension = (StorageTransportExtension)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            LOGGER.info("Initializing storage transport extension. jobId={}", (Object)this.jobInfo.getId());
            extension.initialize(this.jobInfo.getId(), this.conf.getSparkConf(), isOnDriver);
            return extension;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Invalid storage transport extension class specified: '" + transportExtensionClass, e);
        }
    }

    @Override
    public void close() {
        try {
            this.storageClient.close();
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to close StorageClient {}", (Object)this.dataTransferApi.getClass().getSimpleName(), (Object)exception);
        }
    }
}

