/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.io.Serializable;
import java.time.Duration;
import java.util.function.Function;

public final class TTLOption
implements Serializable {
    private static final TTLOption FOREVER = new TTLOption(0);
    private final String ttlColumnName;
    private final Integer ttlInSeconds;

    private TTLOption(String ttlColumnName) {
        this.ttlColumnName = ttlColumnName;
        this.ttlInSeconds = null;
    }

    private TTLOption(int ttlInSeconds) {
        this.ttlInSeconds = ttlInSeconds;
        this.ttlColumnName = null;
    }

    public static TTLOption from(String ttl) {
        if (ttl == null) {
            return FOREVER;
        }
        try {
            return new TTLOption(Integer.parseInt(ttl));
        }
        catch (Exception e) {
            return new TTLOption(ttl);
        }
    }

    public static String constant(int ttlInSeconds) {
        return String.valueOf(ttlInSeconds);
    }

    public static String constant(Duration duration) {
        return String.valueOf(duration.getSeconds());
    }

    public static String perRow(String ttlColumnName) {
        return ttlColumnName;
    }

    public static TTLOption forever() {
        return FOREVER;
    }

    public String columnName() {
        return this.ttlColumnName;
    }

    public boolean withTTl() {
        return !this.equals(FOREVER) && (this.ttlColumnName != null || this.ttlInSeconds != null);
    }

    public String toCQLString(Function<String, String> maybeQuoteFunction) {
        if (this.ttlColumnName != null && !this.ttlColumnName.isEmpty()) {
            return ":" + maybeQuoteFunction.apply(this.ttlColumnName);
        }
        if (this.ttlInSeconds != null) {
            return Integer.toString(this.ttlInSeconds);
        }
        return null;
    }
}

