/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.io.Serializable;
import java.util.UUID;
import org.apache.cassandra.spark.bulkwriter.BroadcastableTokenPartitioner;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterContainer;
import org.jetbrains.annotations.NotNull;

public final class BroadcastableJobInfo
implements Serializable {
    private static final long serialVersionUID = -8717074052066841748L;
    private final BulkSparkConf conf;
    private final MultiClusterContainer<UUID> restoreJobIds;
    private final BroadcastableTokenPartitioner tokenPartitioner;

    public static BroadcastableJobInfo from(@NotNull JobInfo source, @NotNull BulkSparkConf conf) {
        MultiClusterContainer<UUID> restoreJobIds;
        if (source.isCoordinatedWriteEnabled()) {
            CoordinatedWriteConf coordinatedConf = source.coordinatedWriteConf();
            restoreJobIds = new MultiClusterContainer();
            coordinatedConf.clusters().keySet().forEach(clusterId -> restoreJobIds.setValue((String)clusterId, source.getRestoreJobId((String)clusterId)));
        } else {
            restoreJobIds = MultiClusterContainer.ofSingle(source.getRestoreJobId());
        }
        BroadcastableTokenPartitioner broadcastableTokenPartitioner = BroadcastableTokenPartitioner.from(source.getTokenPartitioner());
        return new BroadcastableJobInfo(conf, restoreJobIds, broadcastableTokenPartitioner);
    }

    private BroadcastableJobInfo(BulkSparkConf conf, MultiClusterContainer<UUID> restoreJobIds, BroadcastableTokenPartitioner tokenPartitioner) {
        this.conf = conf;
        this.restoreJobIds = restoreJobIds;
        this.tokenPartitioner = tokenPartitioner;
    }

    public BulkSparkConf getConf() {
        return this.conf;
    }

    public MultiClusterContainer<UUID> getRestoreJobIds() {
        return this.restoreJobIds;
    }

    public BroadcastableTokenPartitioner getBroadcastableTokenPartitioner() {
        return this.tokenPartitioner;
    }
}

