/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.VersionRunner;
import org.apache.cassandra.spark.data.converter.types.SparkType;
import org.apache.spark.sql.types.Decimal;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.quicktheories.QuickTheory;
import org.quicktheories.generators.SourceDSL;

public class CqlFieldComparatorTests
extends VersionRunner {
    private static SparkType toSparkType(CassandraBridge bridge, CqlField.CqlType type) {
        return CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge).toSparkType(type);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testStringComparator(CassandraBridge bridge) {
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.ascii()).compare((Object)"a", (Object)"b") < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.ascii()).compare((Object)"b", (Object)"b")).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.ascii()).compare((Object)"c", (Object)"b") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.ascii()).compare((Object)"b", (Object)"a") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.ascii()).compare((Object)"1", (Object)"2") < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.ascii()).compare((Object)"2", (Object)"2")).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.ascii()).compare((Object)"3", (Object)"2") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.ascii()).compare((Object)"2", (Object)"1") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.timeuuid()).compare((Object)"856f3600-8d57-11e9-9298-798dbb8bb043", (Object)"7a146960-8d57-11e9-94f8-1763d9f66f5e") < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.timeuuid()).compare((Object)"964116b0-8d57-11e9-8097-5f40ae53943c", (Object)"8ebe0600-8d57-11e9-b507-7769fecef72d") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.timeuuid()).compare((Object)"9dda9590-8d57-11e9-9906-8b25b9c1ff19", (Object)"9dda9590-8d57-11e9-9906-8b25b9c1ff19")).isEqualTo(0);
        UUID uuid1 = UUID.randomUUID();
        UUID uuid2 = UUID.randomUUID();
        UUID larger = uuid1.compareTo(uuid2) >= 0 ? uuid1 : uuid2;
        UUID smaller = uuid1.compareTo(uuid2) <= 0 ? uuid1 : uuid2;
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.uuid()).compare((Object)smaller, (Object)larger) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.uuid()).compare((Object)larger, (Object)smaller) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.uuid()).compare((Object)smaller, (Object)smaller)).isEqualTo(0);
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.uuid()).compare((Object)larger, (Object)larger)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.text()).compare((Object)"abc", (Object)"abd") < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.text()).compare((Object)"abd", (Object)"abc") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.text()).compare((Object)"abc", (Object)"abc")).isEqualTo(0);
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.text()).compare((Object)"abd", (Object)"abd")).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.varchar()).compare((Object)"abc", (Object)"abd") < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.varchar()).compare((Object)"abd", (Object)"abc") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.varchar()).compare((Object)"abc", (Object)"abc")).isEqualTo(0);
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.varchar()).compare((Object)"abd", (Object)"abd")).isEqualTo(0);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testBigDecimalComparator(CassandraBridge bridge) {
        BigDecimal value = BigDecimal.valueOf(Long.MAX_VALUE).multiply(BigDecimal.valueOf(2L));
        Decimal decimal1 = Decimal.apply((BigDecimal)value);
        Decimal decimal2 = Decimal.apply((BigDecimal)value.add(BigDecimal.ONE));
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.decimal()).compare((Object)decimal1, (Object)decimal2) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.decimal()).compare((Object)decimal1, (Object)decimal1)).isEqualTo(0);
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.decimal()).compare((Object)decimal2, (Object)decimal2)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.decimal()).compare((Object)decimal2, (Object)decimal1) > 0 ? 1 : 0) != 0).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testVarIntComparator(CassandraBridge bridge) {
        BigDecimal value = BigDecimal.valueOf(Long.MAX_VALUE).multiply(BigDecimal.valueOf(2L));
        Decimal decimal1 = Decimal.apply((BigDecimal)value);
        Decimal decimal2 = Decimal.apply((BigDecimal)value.add(BigDecimal.ONE));
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.varint()).compare((Object)decimal1, (Object)decimal2) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.varint()).compare((Object)decimal1, (Object)decimal1)).isEqualTo(0);
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.varint()).compare((Object)decimal2, (Object)decimal2)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.varint()).compare((Object)decimal2, (Object)decimal1) > 0 ? 1 : 0) != 0).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testIntegerComparator(CassandraBridge bridge) {
        QuickTheory.qt().forAll(SourceDSL.integers().between(Integer.MIN_VALUE, 0x7FFFFFFE)).checkAssert(integer -> {
            Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.aInt()).compare(integer, (Object)(integer + 1)) < 0 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.aInt()).compare(integer, integer)).isEqualTo(0);
            Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.aInt()).compare((Object)(integer + 1), integer) > 0 ? 1 : 0) != 0).isTrue();
        });
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.aInt()).compare((Object)Integer.MAX_VALUE, (Object)Integer.MAX_VALUE)).isEqualTo(0);
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.aInt()).compare((Object)Integer.MIN_VALUE, (Object)Integer.MIN_VALUE)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.aInt()).compare((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.aInt()).compare((Object)Integer.MAX_VALUE, (Object)Integer.MIN_VALUE) > 0 ? 1 : 0) != 0).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testLongComparator(CassandraBridge bridge) {
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.bigint()).compare((Object)0L, (Object)1L) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.bigint()).compare((Object)1L, (Object)1L)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.bigint()).compare((Object)2L, (Object)1L) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.bigint()).compare((Object)Long.MAX_VALUE, (Object)Long.MAX_VALUE)).isEqualTo(0);
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.bigint()).compare((Object)Long.MIN_VALUE, (Object)Long.MIN_VALUE)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.bigint()).compare((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.bigint()).compare((Object)Long.MAX_VALUE, (Object)Long.MIN_VALUE) > 0 ? 1 : 0) != 0).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testTimeComparator(CassandraBridge bridge) {
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.time()).compare((Object)0L, (Object)1L) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.time()).compare((Object)1L, (Object)1L)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.time()).compare((Object)2L, (Object)1L) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.time()).compare((Object)Long.MAX_VALUE, (Object)Long.MAX_VALUE)).isEqualTo(0);
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.time()).compare((Object)Long.MIN_VALUE, (Object)Long.MIN_VALUE)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.time()).compare((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.time()).compare((Object)Long.MAX_VALUE, (Object)Long.MIN_VALUE) > 0 ? 1 : 0) != 0).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testBooleanComparator(CassandraBridge bridge) {
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.bool()).compare((Object)false, (Object)true) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.bool()).compare((Object)false, (Object)false)).isEqualTo(0);
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.bool()).compare((Object)true, (Object)true)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.bool()).compare((Object)true, (Object)false) > 0 ? 1 : 0) != 0).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testFloatComparator(CassandraBridge bridge) {
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.aFloat()).compare((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f)) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.aFloat()).compare((Object)Float.valueOf(2.0f), (Object)Float.valueOf(2.0f))).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.aFloat()).compare((Object)Float.valueOf(2.0f), (Object)Float.valueOf(1.0f)) > 0 ? 1 : 0) != 0).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testDoubleComparator(CassandraBridge bridge) {
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.aDouble()).compare((Object)1.0, (Object)2.0) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.aDouble()).compare((Object)2.0, (Object)2.0)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.aDouble()).compare((Object)2.0, (Object)1.0) > 0 ? 1 : 0) != 0).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testTimestampComparator(CassandraBridge bridge) {
        long timestamp1 = 1L;
        long timestamp2 = 2L;
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.timestamp()).compare((Object)timestamp1, (Object)timestamp2) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.timestamp()).compare((Object)timestamp1, (Object)timestamp1)).isEqualTo(0);
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.timestamp()).compare((Object)timestamp2, (Object)timestamp2)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.timestamp()).compare((Object)timestamp2, (Object)timestamp1) > 0 ? 1 : 0) != 0).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testDateComparator(CassandraBridge bridge) {
        int date1 = 1;
        int date2 = 2;
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.date()).compare((Object)date1, (Object)date2) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.date()).compare((Object)date1, (Object)date1)).isEqualTo(0);
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.date()).compare((Object)date2, (Object)date2)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.date()).compare((Object)date2, (Object)date1) > 0 ? 1 : 0) != 0).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testVoidComparator(CassandraBridge bridge) {
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.empty()).compare(null, null)).isEqualTo(0);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testShortComparator(CassandraBridge bridge) {
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.smallint()).compare((Object)1, (Object)2) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.smallint()).compare((Object)2, (Object)2)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.smallint()).compare((Object)2, (Object)1) > 0 ? 1 : 0) != 0).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testByteArrayComparator(CassandraBridge bridge) {
        byte[] bytes1 = new byte[]{0, 0, 0, 101};
        byte[] bytes2 = new byte[]{0, 0, 0, 102};
        byte[] bytes3 = new byte[]{0, 0, 1, 0};
        byte[] bytes4 = new byte[]{1, 0, 0, 0};
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.blob()).compare((Object)bytes1, (Object)bytes2) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.blob()).compare((Object)bytes1, (Object)bytes1)).isEqualTo(0);
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.blob()).compare((Object)bytes2, (Object)bytes2)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.blob()).compare((Object)bytes2, (Object)bytes1) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.blob()).compare((Object)bytes3, (Object)bytes1) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.blob()).compare((Object)bytes3, (Object)bytes2) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.blob()).compare((Object)bytes4, (Object)bytes3) > 0 ? 1 : 0) != 0).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testInetComparator(CassandraBridge bridge) throws UnknownHostException {
        byte[] ip1 = InetAddress.getByAddress(CqlFieldComparatorTests.toByteArray(2130706433)).getAddress();
        byte[] ip2 = InetAddress.getByAddress(CqlFieldComparatorTests.toByteArray(2130706434)).getAddress();
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.inet()).compare((Object)ip1, (Object)ip2) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.inet()).compare((Object)ip1, (Object)ip1)).isEqualTo(0);
        Assertions.assertThat((int)CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.inet()).compare((Object)ip2, (Object)ip2)).isEqualTo(0);
        Assertions.assertThat((CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.inet()).compare((Object)ip2, (Object)ip1) > 0 ? 1 : 0) != 0).isTrue();
    }

    private static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testByteComparator(CassandraBridge bridge) {
        byte byte1 = 101;
        byte byte2 = 102;
        SparkType type = CqlFieldComparatorTests.toSparkType(bridge, (CqlField.CqlType)bridge.tinyint());
        Assertions.assertThat((int)type.compare((Object)byte1, (Object)byte2)).isLessThan(0);
        Assertions.assertThat((int)type.compare((Object)byte1, (Object)byte1)).isEqualTo(0);
        Assertions.assertThat((int)type.compare((Object)byte2, (Object)byte2)).isEqualTo(0);
        Assertions.assertThat((int)type.compare((Object)byte2, (Object)byte1)).isGreaterThan(0);
    }
}

