/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterContainer;
import org.apache.cassandra.spark.utils.SerializationUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MultiClusterContainerTest {
    MultiClusterContainerTest() {
    }

    @Test
    void testReadAndWriteForSingleTarget() {
        MultiClusterContainer container = new MultiClusterContainer();
        Assertions.assertThat((Object)((Value)container.getValueOrNull(null))).isNull();
        Assertions.assertThat((Object)((Value)container.getValueOrNull("cluster1"))).isNull();
        container.setValue(null, (Object)new Value());
        Assertions.assertThat((Object)((Value)container.getValueOrNull(null))).isNotNull();
        Assertions.assertThat((Object)((Value)container.getValueOrNull("cluster1"))).isNull();
    }

    @Test
    void testReadAndWriteForMultiClusters() {
        MultiClusterContainer container = new MultiClusterContainer();
        container.addAll(Collections.singletonMap("cluster1", new Value()));
        Assertions.assertThat((Object)((Value)container.getValueOrNull("cluster1"))).isNotNull();
        Assertions.assertThat((Object)((Value)container.getValueOrNull("cluster2"))).isNull();
        container.setValue("cluster2", (Object)new Value());
        Assertions.assertThat((Object)((Value)container.getValueOrNull("cluster2"))).isNotNull();
    }

    @Test
    void testSetValueFailsDueToConflict() {
        MultiClusterContainer singleContainer = new MultiClusterContainer();
        singleContainer.setValue(null, (Object)new Value());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> singleContainer.setValue("cluster1", (Object)new Value())).isExactlyInstanceOf(IllegalStateException.class)).hasMessage("Cannot set value for non-null cluster when the container is used for non-coordinated-write");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> singleContainer.addAll(Collections.singletonMap("cluster1", new Value()))).isExactlyInstanceOf(IllegalStateException.class)).hasMessage("Cannot set value for non-null cluster when the container is used for non-coordinated-write");
        MultiClusterContainer multiClusterContainer = new MultiClusterContainer();
        multiClusterContainer.addAll(Collections.singletonMap("cluster1", new Value()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> multiClusterContainer.setValue(null, (Object)new Value())).isExactlyInstanceOf(IllegalStateException.class)).hasMessage("Cannot set value for null cluster when the container is used for coordinated-write");
    }

    @Test
    void testUpdateValue() {
        for (String clusterId : Arrays.asList(null, "cluster1")) {
            MultiClusterContainer container = new MultiClusterContainer();
            container.updateValue(clusterId, v -> {
                Assertions.assertThat((Object)v).isNull();
                return null;
            });
            container.setValue(clusterId, (Object)new Value());
            Assertions.assertThat((int)((Value)container.getValueOrThrow((String)clusterId)).a).isEqualTo(1);
            container.updateValue(clusterId, v -> {
                v.a = 100;
                return v;
            });
            Assertions.assertThat((int)((Value)container.getValueOrThrow((String)clusterId)).a).isEqualTo(100);
            container.updateValue(clusterId, v -> null);
            Assertions.assertThat((Object)((Value)container.getValueOrNull(clusterId))).isNull();
        }
    }

    @Test
    void testHashCodeAndEquals() {
        Value value = new Value();
        MultiClusterContainer container1 = new MultiClusterContainer();
        container1.setValue(null, (Object)value);
        MultiClusterContainer container2 = new MultiClusterContainer();
        container2.setValue(null, (Object)value);
        Assertions.assertThat((int)container1.hashCode()).isEqualTo(container2.hashCode());
        Assertions.assertThat((Object)container1).isEqualTo((Object)container2);
        container1 = new MultiClusterContainer();
        container1.setValue("cluster1", (Object)value);
        container2 = new MultiClusterContainer();
        container2.setValue("cluster1", (Object)value);
        Assertions.assertThat((int)container1.hashCode()).isEqualTo(container2.hashCode());
        Assertions.assertThat((Object)container1).isEqualTo((Object)container2);
        container1.setValue("cluster2", (Object)value);
        Assertions.assertThat((int)container1.hashCode()).isNotEqualTo(container2.hashCode());
        Assertions.assertThat((Object)container1).isNotEqualTo((Object)container2);
    }

    @Test
    void testGetAnyValue() {
        for (String clusterId : Arrays.asList(null, "cluster1")) {
            MultiClusterContainer container = new MultiClusterContainer();
            Assertions.assertThat((Object)((Value)container.getAnyValue())).isNull();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MultiClusterContainer)container).getAnyValueOrThrow()).isInstanceOf(NoSuchElementException.class)).hasMessage("No value is found");
            container.setValue(clusterId, (Object)new Value());
            Assertions.assertThat((Object)((Value)container.getAnyValue())).isNotNull();
        }
    }

    @Test
    void testSize() {
        MultiClusterContainer container = new MultiClusterContainer();
        Assertions.assertThat((int)container.size()).isZero();
        container.setValue("cluster1", (Object)new Value());
        Assertions.assertThat((int)container.size()).isOne();
        container.setValue("cluster2", (Object)new Value());
        Assertions.assertThat((int)container.size()).isEqualTo(2);
        container = new MultiClusterContainer();
        container.setValue(null, (Object)new Value());
        container.setValue(null, (Object)new Value());
        Assertions.assertThat((int)container.size()).isOne();
    }

    @Test
    void testForEach() {
        MultiClusterContainer container = new MultiClusterContainer();
        container.forEach((clusterId, value) -> Assertions.fail((String)"should not reach here"));
        container.setValue(null, (Object)new Value());
        container.forEach((clusterId, v) -> Assertions.assertThat((String)clusterId).isNull());
        container = new MultiClusterContainer();
        Value v1 = new Value();
        Value v2 = new Value();
        container.setValue("cluster1", (Object)v1);
        container.setValue("cluster2", (Object)v2);
        container.forEach((clusterId, value) -> {
            Assertions.assertThat((String)clusterId).isIn(new Object[]{"cluster1", "cluster2"});
            if (clusterId.equals("cluster1")) {
                Assertions.assertThat((Object)value).isSameAs((Object)v1);
            } else {
                Assertions.assertThat((Object)value).isSameAs((Object)v2);
            }
        });
    }

    @Test
    void testSerializationAndDeserializationWithSingleClusterContainer() throws IOException, ClassNotFoundException {
        UUID expectedJobId = UUID.randomUUID();
        MultiClusterContainer container = MultiClusterContainer.ofSingle((Object)expectedJobId);
        byte[] serialized = SerializationUtils.serialize(container);
        MultiClusterContainer deserializedContainer = SerializationUtils.deserialize(serialized, MultiClusterContainer.class);
        Assertions.assertThat((Comparable)((UUID)deserializedContainer.getValueOrNull(null))).isEqualTo((Object)expectedJobId);
        Assertions.assertThat((int)deserializedContainer.size()).isOne();
        Assertions.assertThat((Comparable)((UUID)deserializedContainer.getAnyValue())).isEqualTo((Object)expectedJobId);
    }

    @Test
    void testSerializationAndDeserializationWithMultiClusterContainer() throws IOException, ClassNotFoundException {
        UUID cluster1JobId = UUID.randomUUID();
        UUID cluster2JobId = UUID.randomUUID();
        MultiClusterContainer container = new MultiClusterContainer();
        container.setValue("cluster1", (Object)cluster1JobId);
        container.setValue("cluster2", (Object)cluster2JobId);
        byte[] serialized = SerializationUtils.serialize(container);
        MultiClusterContainer deserializedContainer = SerializationUtils.deserialize(serialized, MultiClusterContainer.class);
        Assertions.assertThat((Comparable)((UUID)deserializedContainer.getValueOrNull("cluster1"))).isEqualTo((Object)cluster1JobId);
        Assertions.assertThat((Comparable)((UUID)deserializedContainer.getValueOrNull("cluster2"))).isEqualTo((Object)cluster2JobId);
        Assertions.assertThat((Comparable)((UUID)deserializedContainer.getValueOrNull(null))).isNull();
        Assertions.assertThat((int)deserializedContainer.size()).isEqualTo(2);
        UUID anyValue = (UUID)deserializedContainer.getAnyValue();
        Assertions.assertThat((Comparable)anyValue).isIn(new Object[]{cluster1JobId, cluster2JobId});
    }

    private static class Value {
        int a = 1;

        private Value() {
        }
    }
}

