/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.spark.bulkwriter.DecoratedKey;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.TokenPartitioner;
import org.apache.cassandra.spark.bulkwriter.TokenRangeMappingUtils;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TokenPartitionerTest {
    private TokenPartitioner partitioner;

    @BeforeEach
    public void createConfig() {
    }

    @Test
    public void testOneSplit() {
        TokenRangeMapping<RingInstance> tokenRangeMapping = TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3), 3);
        this.partitioner = new TokenPartitioner(tokenRangeMapping, Integer.valueOf(1), 2, Integer.valueOf(1), false);
        Assertions.assertThat((int)this.partitioner.numPartitions()).isEqualTo(4);
        Assertions.assertThat((int)this.partitionForToken(new BigInteger("-9223372036854775807"))).isEqualTo(0);
        Assertions.assertThat((int)this.partitionForToken(0)).isEqualTo(0);
        Assertions.assertThat((int)this.partitionForToken(1)).isEqualTo(1);
        Assertions.assertThat((int)this.partitionForToken(100001)).isEqualTo(2);
        Assertions.assertThat((int)this.partitionForToken(200001)).isEqualTo(3);
        Assertions.assertThat((int)this.partitionForToken(new BigInteger("9223372036854775807"))).isEqualTo(3);
    }

    @Test
    public void testTwoSplits() {
        TokenRangeMapping<RingInstance> tokenRangeMapping = TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3), 3);
        this.partitioner = new TokenPartitioner(tokenRangeMapping, Integer.valueOf(2), 2, Integer.valueOf(1), false);
        Assertions.assertThat((int)this.partitioner.numPartitions()).isEqualTo(8);
        Assertions.assertThat((int)this.partitionForToken(new BigInteger("-9223372036854775808"))).isEqualTo(0);
        Assertions.assertThat((int)this.partitionForToken(new BigInteger("-9223372036854775807"))).isEqualTo(0);
        Assertions.assertThat((int)this.partitionForToken(new BigInteger("-4611686018427387904"))).isEqualTo(0);
        Assertions.assertThat((int)this.partitionForToken(new BigInteger("-4611686018427387903"))).isEqualTo(1);
        Assertions.assertThat((int)this.partitionForToken(0)).isEqualTo(1);
        Assertions.assertThat((int)this.partitionForToken(1)).isEqualTo(2);
        Assertions.assertThat((int)this.partitionForToken(50)).isEqualTo(2);
        Assertions.assertThat((int)this.partitionForToken(51000)).isEqualTo(3);
        Assertions.assertThat((int)this.partitionForToken(51100)).isEqualTo(3);
        Assertions.assertThat((int)this.partitionForToken(100001)).isEqualTo(4);
        Assertions.assertThat((int)this.partitionForToken(100150)).isEqualTo(4);
        Assertions.assertThat((int)this.partitionForToken(150000)).isEqualTo(4);
        Assertions.assertThat((int)this.partitionForToken(150001)).isEqualTo(5);
        Assertions.assertThat((int)this.partitionForToken(200000)).isEqualTo(5);
        Assertions.assertThat((int)this.partitionForToken(200001)).isEqualTo(6);
        Assertions.assertThat((int)this.partitionForToken(new BigInteger("4611686018427388003"))).isEqualTo(6);
        Assertions.assertThat((int)this.partitionForToken(new BigInteger("4611686018427487904"))).isEqualTo(6);
        Assertions.assertThat((int)this.partitionForToken(new BigInteger("4611686018427487905"))).isEqualTo(7);
        Assertions.assertThat((int)this.partitionForToken(new BigInteger("9223372036854775807"))).isEqualTo(7);
    }

    @Test
    public void testReplicationFactorInOneDCOnly() {
        TokenRangeMapping<RingInstance> tokenRangeMapping = TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3, (Object)"DC2", (Object)0), 3);
        this.partitioner = new TokenPartitioner(tokenRangeMapping, Integer.valueOf(1), 2, Integer.valueOf(1), false);
        Assertions.assertThat((int)this.partitioner.numPartitions()).isEqualTo(4);
        Assertions.assertThat((int)this.partitionForToken(new BigInteger("-9223372036854775807"))).isEqualTo(0);
        Assertions.assertThat((int)this.partitionForToken(0)).isEqualTo(0);
        Assertions.assertThat((int)this.partitionForToken(100000)).isEqualTo(1);
        Assertions.assertThat((int)this.partitionForToken(100001)).isEqualTo(2);
        Assertions.assertThat((int)this.partitionForToken(200001)).isEqualTo(3);
        Assertions.assertThat((int)this.partitionForToken(new BigInteger("9223372036854775807"))).isEqualTo(3);
    }

    @Test
    public void testSplitCalculationsUsingCores() {
        TokenRangeMapping<RingInstance> tokenRangeMapping = TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3), 3);
        this.partitioner = new TokenPartitioner(tokenRangeMapping, Integer.valueOf(-1), 50, Integer.valueOf(100), false);
        Assertions.assertThat((int)this.partitioner.numSplits()).isEqualTo(25);
        Assertions.assertThat((int)this.partitioner.numPartitions()).isGreaterThanOrEqualTo(100);
    }

    @Test
    public void testSplitCalculationsUsingDefaultParallelism() {
        TokenRangeMapping<RingInstance> tokenRangeMapping = TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3), 3);
        this.partitioner = new TokenPartitioner(tokenRangeMapping, Integer.valueOf(-1), 200, Integer.valueOf(100), false);
        Assertions.assertThat((int)this.partitioner.numSplits()).isEqualTo(50);
        Assertions.assertThat((int)this.partitioner.numPartitions()).isGreaterThanOrEqualTo(200);
    }

    @Test
    public void testSplitCalculationWithMultipleDcs() {
        ImmutableMap dcMap = ImmutableMap.builder().put((Object)"DC1", (Object)3).put((Object)"DC2", (Object)3).put((Object)"DC3", (Object)3).put((Object)"DC4", (Object)3).build();
        TokenRangeMapping<RingInstance> tokenRangeMapping = TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)dcMap, 20);
        this.partitioner = new TokenPartitioner(tokenRangeMapping, Integer.valueOf(-1), 1, Integer.valueOf(750), false);
        Assertions.assertThat((int)this.partitioner.numSplits()).isEqualTo(10);
        Assertions.assertThat((int)this.partitioner.numPartitions()).isGreaterThanOrEqualTo(200);
    }

    private int partitionForToken(int token) {
        return this.partitionForToken(BigInteger.valueOf(token));
    }

    private int partitionForToken(BigInteger token) {
        return this.partitioner.getPartition((Object)new DecoratedKey(token, ByteBuffer.allocate(0)));
    }
}

