/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.LongPredicate;
import java.util.stream.Collectors;
import org.apache.cassandra.db.AbstractCompactionController;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.CompactionIterator;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.reader.AbstractStreamScanner;
import org.apache.cassandra.spark.reader.Scannable;
import org.apache.cassandra.spark.utils.IOUtils;
import org.apache.cassandra.spark.utils.TimeProvider;
import org.jetbrains.annotations.NotNull;

public class CompactionStreamScanner
extends AbstractStreamScanner {
    private final Collection<? extends Scannable> toCompact;
    private final UUID taskId;
    private PurgingCompactionController controller;
    private AbstractCompactionStrategy.ScannerList scanners;
    private CompactionIterator ci;

    @VisibleForTesting
    CompactionStreamScanner(@NotNull TableMetadata cfMetaData, @NotNull Partitioner partitionerType, @NotNull Collection<? extends Scannable> toCompact) {
        this(cfMetaData, partitionerType, TimeProvider.DEFAULT, toCompact);
    }

    public CompactionStreamScanner(@NotNull TableMetadata cfMetaData, @NotNull Partitioner partitionerType, @NotNull TimeProvider timeProvider, @NotNull Collection<? extends Scannable> toCompact) {
        super(cfMetaData, partitionerType, timeProvider);
        this.toCompact = toCompact;
        this.taskId = UUID.randomUUID();
    }

    @Override
    public void close() {
        Arrays.asList(this.controller, this.scanners, this.ci).forEach(IOUtils::closeQuietly);
    }

    @Override
    protected void handleRowTombstone(BigInteger token, Row row) {
        throw new IllegalStateException("Row tombstone found. It should have been purged in CompactionIterator.Partition key token: " + String.valueOf(token));
    }

    @Override
    protected void handlePartitionTombstone(BigInteger token, UnfilteredRowIterator partition) {
        throw new IllegalStateException("Partition tombstone found. It should have been purged in CompactionIterator. Partition key token: " + String.valueOf(token));
    }

    @Override
    protected void handleCellTombstone(BigInteger token) {
        throw new IllegalStateException("Cell tombstone found. It should have been purged in CompactionIterator. Partition key token: " + String.valueOf(token));
    }

    @Override
    protected void handleCellTombstoneInComplex(BigInteger token, Cell<?> cell) {
        throw new IllegalStateException("Cell tombstone in complex type found. It should have been purged in CompactionIterator. Partition key token: " + String.valueOf(token));
    }

    @Override
    UnfilteredPartitionIterator initializePartitions() {
        int nowInSec = this.timeProvider.referenceEpochInSeconds();
        Keyspace keyspace = Keyspace.openWithoutSSTables((String)this.metadata.keyspace);
        ColumnFamilyStore cfStore = keyspace.getColumnFamilyStore(this.metadata.name);
        this.controller = new PurgingCompactionController(cfStore, CompactionParams.TombstoneOption.NONE);
        List scannerList = this.toCompact.stream().map(Scannable::scanner).collect(Collectors.toList());
        this.scanners = new AbstractCompactionStrategy.ScannerList(scannerList);
        this.ci = new CompactionIterator(OperationType.COMPACTION, this.scanners.scanners, (AbstractCompactionController)this.controller, nowInSec, this.taskId);
        return this.ci;
    }

    private static class PurgingCompactionController
    extends AbstractCompactionController
    implements AutoCloseable {
        PurgingCompactionController(ColumnFamilyStore cfs, CompactionParams.TombstoneOption tombstoneOption) {
            super(cfs, Integer.MAX_VALUE, tombstoneOption);
        }

        public boolean compactingRepaired() {
            return false;
        }

        public LongPredicate getPurgeEvaluator(DecoratedKey key) {
            return time -> true;
        }

        @Override
        public void close() {
        }
    }
}

