/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.CassandraSchema;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.TypeCodec;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.DeleteStatement;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.schema.CreateTableStatement;
import org.apache.cassandra.cql3.statements.schema.CreateTypeStatement;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableSimpleUnsortedWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

@VisibleForTesting
public final class SSTableTombstoneWriter
implements Closeable {
    private static final ByteBuffer UNSET_VALUE = ByteBufferUtil.UNSET_BYTE_BUFFER;
    private final AbstractSSTableSimpleWriter writer;
    private final DeleteStatement delete;
    private final List<ColumnSpecification> boundNames;
    private final List<TypeCodec> typeCodecs;
    private final ClusteringComparator comparator;

    private SSTableTombstoneWriter(AbstractSSTableSimpleWriter writer, DeleteStatement delete, List<ColumnSpecification> boundNames, ClusteringComparator comparator) {
        this.writer = writer;
        this.delete = delete;
        this.boundNames = boundNames;
        this.typeCodecs = boundNames.stream().map(bn -> UDHelper.codecFor((DataType)UDHelper.driverType((AbstractType)bn.type))).collect(Collectors.toList());
        this.comparator = comparator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void addRow(Object ... values) throws InvalidRequestException, IOException {
        this.addRow(Arrays.asList(values));
    }

    private void addRow(List<Object> values) throws InvalidRequestException, IOException {
        int size = Math.min(values.size(), this.boundNames.size());
        ArrayList<ByteBuffer> rawValues = new ArrayList<ByteBuffer>(size);
        for (int index = 0; index < size; ++index) {
            Object value = values.get(index);
            rawValues.add(this.serialize(value, this.typeCodecs.get(index)));
        }
        this.rawAddRow(rawValues);
    }

    private void rawAddRow(List<ByteBuffer> values) throws InvalidRequestException, IOException {
        if (values.size() != this.boundNames.size()) {
            throw new InvalidRequestException(String.format("Invalid number of arguments, expecting %d values but got %d", this.boundNames.size(), values.size()));
        }
        QueryOptions options = QueryOptions.forInternalCalls(null, values);
        List keys = this.delete.buildPartitionKeyNames(options);
        long now = System.currentTimeMillis();
        UpdateParameters params = new UpdateParameters(this.delete.metadata, this.delete.updatedColumns(), options, this.delete.getTimestamp(TimeUnit.MILLISECONDS.toMicros(now), options), (int)TimeUnit.MILLISECONDS.toSeconds(now), this.delete.getTimeToLive(options), Collections.emptyMap());
        if (this.delete.hasSlices()) {
            NavigableSet startBounds = this.delete.getRestrictions().getClusteringColumnsBounds(Bound.START, options);
            NavigableSet endBounds = this.delete.getRestrictions().getClusteringColumnsBounds(Bound.END, options);
            Slices slices = this.toSlices(startBounds, endBounds);
            try {
                for (ByteBuffer key : keys) {
                    for (Slice slice : slices) {
                        this.delete.addUpdateForKey(this.writer.getUpdateFor(key), slice, params);
                    }
                }
                return;
            }
            catch (SSTableSimpleUnsortedWriter.SyncException exception) {
                throw (IOException)exception.getCause();
            }
        }
        NavigableSet clusterings = this.delete.createClustering(options);
        try {
            for (ByteBuffer key : keys) {
                for (Clustering clustering : clusterings) {
                    this.delete.addUpdateForKey(this.writer.getUpdateFor(key), clustering, params);
                }
            }
        }
        catch (SSTableSimpleUnsortedWriter.SyncException exception) {
            throw (IOException)exception.getCause();
        }
    }

    private Slices toSlices(SortedSet<ClusteringBound<?>> startBounds, SortedSet<ClusteringBound<?>> endBounds) {
        assert (startBounds.size() == endBounds.size());
        Slices.Builder builder = new Slices.Builder(this.comparator);
        Iterator starts = startBounds.iterator();
        Iterator ends = endBounds.iterator();
        while (starts.hasNext()) {
            Slice slice = Slice.make((ClusteringBound)((ClusteringBound)starts.next()), (ClusteringBound)((ClusteringBound)ends.next()));
            if (slice.isEmpty(this.comparator)) continue;
            builder.add(slice);
        }
        return builder.build();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private ByteBuffer serialize(Object value, TypeCodec codec) {
        if (value == null || value == UNSET_VALUE) {
            return (ByteBuffer)value;
        }
        return codec.serialize(value, ProtocolVersion.CURRENT);
    }

    static {
        DatabaseDescriptor.clientInitialization((boolean)false);
        if (DatabaseDescriptor.getPartitioner() == null) {
            DatabaseDescriptor.setPartitionerUnsafe((IPartitioner)Murmur3Partitioner.instance);
        }
    }

    public static class Builder {
        private File directory;
        SSTableFormat.Type formatType = null;
        private CreateTableStatement.Raw schemaStatement;
        private final List<CreateTypeStatement.Raw> typeStatements = new ArrayList<CreateTypeStatement.Raw>();
        private ModificationStatement.Parsed deleteStatement;
        private IPartitioner partitioner;
        private long bufferSizeInMB = 128L;

        Builder() {
        }

        public Builder inDirectory(File directory) {
            if (!directory.exists()) {
                throw new IllegalArgumentException(String.valueOf(directory) + " doesn't exists");
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(String.valueOf(directory) + " exists but is not writable");
            }
            this.directory = directory;
            return this;
        }

        public Builder forTable(String schema) {
            this.schemaStatement = (CreateTableStatement.Raw)QueryProcessor.parseStatement((String)schema, CreateTableStatement.Raw.class, (String)"CREATE TABLE");
            return this;
        }

        public Builder withPartitioner(IPartitioner partitioner) {
            this.partitioner = partitioner;
            return this;
        }

        public Builder using(String delete) {
            this.deleteStatement = (ModificationStatement.Parsed)QueryProcessor.parseStatement((String)delete, ModificationStatement.Parsed.class, (String)"DELETE");
            return this;
        }

        public Builder withBufferSizeInMB(int size) {
            this.bufferSizeInMB = size;
            return this;
        }

        public SSTableTombstoneWriter build() {
            if (this.directory == null) {
                throw new IllegalStateException("No ouptut directory specified, you should provide a directory with inDirectory()");
            }
            if (this.schemaStatement == null) {
                throw new IllegalStateException("Missing schema, you should provide the schema for the SSTable to create with forTable()");
            }
            if (this.deleteStatement == null) {
                throw new IllegalStateException("No delete statement specified, you should provide a delete statement through using()");
            }
            TableMetadata tableMetadata = (TableMetadata)CassandraSchema.apply(schema -> {
                String keyspaceName;
                if (schema.getKeyspaceMetadata("system") == null) {
                    schema.load(SystemKeyspace.metadata());
                }
                if (schema.getKeyspaceMetadata(keyspaceName = this.schemaStatement.keyspace()) == null) {
                    schema.load(KeyspaceMetadata.create((String)keyspaceName, (KeyspaceParams)KeyspaceParams.simple((int)1), (Tables)Tables.none(), (Views)Views.none(), (Types)Types.none(), (Functions)Functions.none()));
                }
                KeyspaceMetadata ksm = schema.getKeyspaceMetadata(keyspaceName);
                TableMetadata table = ksm.tables.getNullable(this.schemaStatement.table());
                if (table == null) {
                    Types types = this.createTypes(keyspaceName);
                    table = this.createTable(types);
                    schema.load(ksm.withSwapped(ksm.tables.with(table)).withSwapped(types));
                }
                return table;
            });
            DeleteStatement preparedDelete = this.prepareDelete();
            TableMetadataRef ref = TableMetadataRef.forOfflineTools((TableMetadata)tableMetadata);
            SSTableSimpleUnsortedWriter writer = new SSTableSimpleUnsortedWriter(this.directory, ref, preparedDelete.updatedColumns(), this.bufferSizeInMB);
            if (this.formatType != null) {
                writer.setSSTableFormatType(this.formatType);
            }
            return new SSTableTombstoneWriter((AbstractSSTableSimpleWriter)writer, preparedDelete, preparedDelete.getBindVariables(), tableMetadata.comparator);
        }

        private Types createTypes(String keyspace) {
            Types.RawBuilder builder = Types.rawBuilder((String)keyspace);
            for (CreateTypeStatement.Raw st : this.typeStatements) {
                st.addToRawBuilder(builder);
            }
            return builder.build();
        }

        private TableMetadata createTable(Types types) {
            ClientState state = ClientState.forInternalCalls();
            CreateTableStatement statement = this.schemaStatement.prepare(state);
            statement.validate(ClientState.forInternalCalls());
            TableMetadata.Builder builder = statement.builder(types);
            if (this.partitioner != null) {
                builder.partitioner(this.partitioner);
            }
            return builder.build();
        }

        private DeleteStatement prepareDelete() {
            ClientState state = ClientState.forInternalCalls();
            DeleteStatement delete = (DeleteStatement)this.deleteStatement.prepare(state);
            delete.validate(state);
            if (delete.hasConditions()) {
                throw new IllegalArgumentException("Conditional statements are not supported");
            }
            if (delete.isCounter()) {
                throw new IllegalArgumentException("Counter update statements are not supported");
            }
            if (delete.getBindVariables().isEmpty()) {
                throw new IllegalArgumentException("Provided delete statement has no bind variables");
            }
            return delete;
        }
    }
}

