/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.ext.web.client.impl.cache;

import o.a.c.sidecar.client.shaded.io.vertx.core.Future;
import o.a.c.sidecar.client.shaded.io.vertx.core.Vertx;
import o.a.c.sidecar.client.shaded.io.vertx.core.shareddata.AsyncMap;
import o.a.c.sidecar.client.shaded.io.vertx.core.shareddata.SharedData;
import o.a.c.sidecar.client.shaded.io.vertx.ext.web.client.impl.cache.CacheKey;
import o.a.c.sidecar.client.shaded.io.vertx.ext.web.client.impl.cache.CachedHttpResponse;
import o.a.c.sidecar.client.shaded.io.vertx.ext.web.client.spi.CacheStore;

public class SharedDataCacheStore
implements CacheStore {
    private static final String ASYNC_MAP_NAME = "HttpCacheStore";
    private final SharedData sharedData;

    public SharedDataCacheStore(Vertx vertx) {
        this.sharedData = vertx.sharedData();
    }

    @Override
    public Future<CachedHttpResponse> get(CacheKey key) {
        return this.asyncMap().compose(map -> map.get(key));
    }

    @Override
    public Future<CachedHttpResponse> set(CacheKey key, CachedHttpResponse response) {
        return this.asyncMap().compose(map -> map.put(key, response)).map(response);
    }

    @Override
    public Future<Void> delete(CacheKey key) {
        return this.asyncMap().compose(map -> map.remove(key)).mapEmpty();
    }

    @Override
    public Future<Void> flush() {
        return this.asyncMap().compose(AsyncMap::clear);
    }

    private Future<AsyncMap<CacheKey, CachedHttpResponse>> asyncMap() {
        return this.sharedData.getAsyncMap(ASYNC_MAP_NAME);
    }
}

