/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import o.a.c.sidecar.client.shaded.io.vertx.core.AsyncResult;
import o.a.c.sidecar.client.shaded.io.vertx.core.Future;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.MultiMap;
import o.a.c.sidecar.client.shaded.io.vertx.core.Promise;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.DeliveryContext;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.DeliveryOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.EventBus;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.Message;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.MessageCodec;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.MessageConsumer;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.MessageProducer;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.ReplyException;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.ReplyFailure;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.CodecManager;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.EventBusInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.HandlerHolder;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.HandlerRegistration;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.MessageConsumerImpl;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.MessageImpl;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.MessageProducerImpl;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.OutboundDeliveryContext;
import o.a.c.sidecar.client.shaded.io.vertx.core.eventbus.impl.ReplyHandler;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.ContextInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.VertxInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.utils.ConcurrentCyclicSequence;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.EventBusMetrics;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.MetricsProvider;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.VertxMetrics;

public class EventBusImpl
implements EventBusInternal,
MetricsProvider {
    private static final AtomicReferenceFieldUpdater<EventBusImpl, Handler[]> OUTBOUND_INTERCEPTORS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(EventBusImpl.class, Handler[].class, "outboundInterceptors");
    private static final AtomicReferenceFieldUpdater<EventBusImpl, Handler[]> INBOUND_INTERCEPTORS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(EventBusImpl.class, Handler[].class, "inboundInterceptors");
    private volatile Handler<DeliveryContext>[] outboundInterceptors = new Handler[0];
    private volatile Handler<DeliveryContext>[] inboundInterceptors = new Handler[0];
    private final AtomicLong replySequence = new AtomicLong(0L);
    protected final VertxInternal vertx;
    protected final EventBusMetrics metrics;
    protected final ConcurrentMap<String, ConcurrentCyclicSequence<HandlerHolder>> handlerMap = new ConcurrentHashMap<String, ConcurrentCyclicSequence<HandlerHolder>>();
    protected final CodecManager codecManager = new CodecManager();
    protected volatile boolean started;

    public EventBusImpl(VertxInternal vertx) {
        VertxMetrics metrics = vertx.metricsSPI();
        this.vertx = vertx;
        this.metrics = metrics != null ? metrics.createEventBusMetrics() : null;
    }

    @Override
    public <T> EventBus addOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.addInterceptor(OUTBOUND_INTERCEPTORS_UPDATER, Objects.requireNonNull(interceptor));
        return this;
    }

    @Override
    public <T> EventBus addInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.addInterceptor(INBOUND_INTERCEPTORS_UPDATER, Objects.requireNonNull(interceptor));
        return this;
    }

    @Override
    public <T> EventBus removeOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.removeInterceptor(OUTBOUND_INTERCEPTORS_UPDATER, Objects.requireNonNull(interceptor));
        return this;
    }

    @Override
    public <T> EventBus removeInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.removeInterceptor(INBOUND_INTERCEPTORS_UPDATER, Objects.requireNonNull(interceptor));
        return this;
    }

    Handler<DeliveryContext>[] inboundInterceptors() {
        return this.inboundInterceptors;
    }

    Handler<DeliveryContext>[] outboundInterceptors() {
        return this.outboundInterceptors;
    }

    @Override
    public EventBus clusterSerializableChecker(Function<String, Boolean> classNamePredicate) {
        this.codecManager.clusterSerializableCheck(classNamePredicate);
        return this;
    }

    @Override
    public EventBus serializableChecker(Function<String, Boolean> classNamePredicate) {
        this.codecManager.serializableCheck(classNamePredicate);
        return this;
    }

    @Override
    public synchronized void start(Promise<Void> promise) {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        promise.complete();
    }

    @Override
    public EventBus send(String address, Object message) {
        return this.send(address, message, new DeliveryOptions());
    }

    @Override
    public EventBus send(String address, Object message, DeliveryOptions options) {
        MessageImpl msg = this.createMessage(true, this.isLocalOnly(options), address, options.getHeaders(), message, options.getCodecName());
        this.sendOrPubInternal(msg, options, null, null);
        return this;
    }

    @Override
    public <T> Future<Message<T>> request(String address, Object message, DeliveryOptions options) {
        MessageImpl msg = this.createMessage(true, this.isLocalOnly(options), address, options.getHeaders(), message, options.getCodecName());
        ReplyHandler<T> handler = this.createReplyHandler(msg, true, options);
        this.sendOrPubInternal(msg, options, handler, null);
        return handler.result();
    }

    @Override
    public <T> MessageProducer<T> sender(String address) {
        Objects.requireNonNull(address, "address");
        return new MessageProducerImpl(this.vertx, address, true, new DeliveryOptions());
    }

    @Override
    public <T> MessageProducer<T> sender(String address, DeliveryOptions options) {
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(options, "options");
        return new MessageProducerImpl(this.vertx, address, true, options);
    }

    @Override
    public <T> MessageProducer<T> publisher(String address) {
        Objects.requireNonNull(address, "address");
        return new MessageProducerImpl(this.vertx, address, false, new DeliveryOptions());
    }

    @Override
    public <T> MessageProducer<T> publisher(String address, DeliveryOptions options) {
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(options, "options");
        return new MessageProducerImpl(this.vertx, address, false, options);
    }

    @Override
    public EventBus publish(String address, Object message) {
        return this.publish(address, message, new DeliveryOptions());
    }

    @Override
    public EventBus publish(String address, Object message, DeliveryOptions options) {
        this.sendOrPubInternal(this.createMessage(false, this.isLocalOnly(options), address, options.getHeaders(), message, options.getCodecName()), options, null, null);
        return this;
    }

    @Override
    public <T> MessageConsumer<T> consumer(String address) {
        this.checkStarted();
        Objects.requireNonNull(address, "address");
        return new MessageConsumerImpl(this.vertx, this.vertx.getOrCreateContext(), this, address, false);
    }

    @Override
    public <T> MessageConsumer<T> consumer(String address, Handler<Message<T>> handler) {
        Objects.requireNonNull(handler, "handler");
        MessageConsumer<T> consumer = this.consumer(address);
        consumer.handler((Handler)handler);
        return consumer;
    }

    @Override
    public <T> MessageConsumer<T> localConsumer(String address) {
        this.checkStarted();
        Objects.requireNonNull(address, "address");
        return new MessageConsumerImpl(this.vertx, this.vertx.getOrCreateContext(), this, address, true);
    }

    @Override
    public <T> MessageConsumer<T> localConsumer(String address, Handler<Message<T>> handler) {
        Objects.requireNonNull(handler, "handler");
        MessageConsumer<T> consumer = this.localConsumer(address);
        consumer.handler((Handler)handler);
        return consumer;
    }

    @Override
    public EventBus registerCodec(MessageCodec codec) {
        this.codecManager.registerCodec(codec);
        return this;
    }

    @Override
    public EventBus unregisterCodec(String name) {
        this.codecManager.unregisterCodec(name);
        return this;
    }

    @Override
    public <T> EventBus registerDefaultCodec(Class<T> clazz, MessageCodec<T, ?> codec) {
        this.codecManager.registerDefaultCodec(clazz, codec);
        return this;
    }

    @Override
    public EventBus unregisterDefaultCodec(Class clazz) {
        this.codecManager.unregisterDefaultCodec(clazz);
        return this;
    }

    @Override
    public EventBus codecSelector(Function<Object, String> selector) {
        this.codecManager.codecSelector(selector);
        return this;
    }

    @Override
    public void close(Promise<Void> promise) {
        if (!this.started) {
            promise.complete();
            return;
        }
        this.unregisterAll().onComplete(ar -> {
            if (this.metrics != null) {
                this.metrics.close();
            }
            promise.handle((AsyncResult<Void>)ar);
        });
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public EventBusMetrics<?> getMetrics() {
        return this.metrics;
    }

    public MessageImpl createMessage(boolean send, boolean localOnly, String address, MultiMap headers, Object body, String codecName) {
        Objects.requireNonNull(address, "no null address accepted");
        MessageCodec codec = this.codecManager.lookupCodec(body, codecName, localOnly);
        MessageImpl msg = new MessageImpl(address, headers, body, codec, send, this);
        return msg;
    }

    protected <T> HandlerHolder<T> addRegistration(String address, HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly, Promise<Void> promise) {
        HandlerHolder<T> holder = this.addLocalRegistration(address, registration, replyHandler, localOnly);
        this.onLocalRegistration(holder, promise);
        return holder;
    }

    protected <T> void onLocalRegistration(HandlerHolder<T> handlerHolder, Promise<Void> promise) {
        if (promise != null) {
            promise.complete();
        }
    }

    private <T> HandlerHolder<T> addLocalRegistration(String address, HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly) {
        Objects.requireNonNull(address, "address");
        ContextInternal context = registration.context;
        HandlerHolder<T> holder = this.createHandlerHolder(registration, replyHandler, localOnly, context);
        ConcurrentCyclicSequence<HandlerHolder<T>> handlers = new ConcurrentCyclicSequence<HandlerHolder<T>>().add(holder);
        ConcurrentCyclicSequence actualHandlers = this.handlerMap.merge(address, handlers, (old, prev) -> old.add(prev.first()));
        if (context.isDeployment()) {
            context.addCloseHook(registration);
        }
        return holder;
    }

    protected <T> HandlerHolder<T> createHandlerHolder(HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly, ContextInternal context) {
        return new HandlerHolder<T>(registration, replyHandler, localOnly, context);
    }

    protected <T> void removeRegistration(HandlerHolder<T> handlerHolder, Promise<Void> promise) {
        this.removeLocalRegistration(handlerHolder);
        this.onLocalUnregistration(handlerHolder, promise);
    }

    protected <T> void onLocalUnregistration(HandlerHolder<T> handlerHolder, Promise<Void> promise) {
        promise.complete();
    }

    private <T> void removeLocalRegistration(HandlerHolder<T> holder) {
        String address = holder.getHandler().address;
        this.handlerMap.compute(address, (key, val) -> {
            if (val == null) {
                return null;
            }
            ConcurrentCyclicSequence<HandlerHolder> next = val.remove(holder);
            return next.size() == 0 ? null : next;
        });
        if (holder.setRemoved() && holder.getContext().deploymentID() != null) {
            holder.getContext().removeCloseHook(holder.getHandler());
        }
    }

    protected <T> void sendReply(MessageImpl replyMessage, DeliveryOptions options, ReplyHandler<T> replyHandler) {
        if (replyMessage.address() == null) {
            throw new IllegalStateException("address not specified");
        }
        this.sendOrPubInternal(new OutboundDeliveryContext<T>(this.vertx.getOrCreateContext(), replyMessage, options, replyHandler, null));
    }

    protected <T> void sendOrPub(OutboundDeliveryContext<T> sendContext) {
        this.sendLocally(sendContext);
    }

    protected void callCompletionHandlerAsync(Handler<AsyncResult<Void>> completionHandler) {
        if (completionHandler != null) {
            this.vertx.runOnContext(v -> completionHandler.handle(Future.succeededFuture()));
        }
    }

    private <T> void sendLocally(OutboundDeliveryContext<T> sendContext) {
        ReplyException failure = this.deliverMessageLocally(sendContext.message);
        if (failure != null) {
            sendContext.written(failure);
        } else {
            sendContext.written(null);
        }
    }

    protected boolean isMessageLocal(MessageImpl msg) {
        return true;
    }

    protected ReplyException deliverMessageLocally(MessageImpl msg) {
        ConcurrentCyclicSequence handlers = (ConcurrentCyclicSequence)this.handlerMap.get(msg.address());
        boolean messageLocal = this.isMessageLocal(msg);
        if (handlers != null) {
            if (msg.isSend()) {
                HandlerHolder holder = this.nextHandler(handlers, messageLocal);
                if (this.metrics != null) {
                    this.metrics.messageReceived(msg.address(), !msg.isSend(), messageLocal, holder != null ? 1 : 0);
                }
                if (holder != null) {
                    holder.handler.receive(msg.copyBeforeReceive());
                }
            } else {
                if (this.metrics != null) {
                    this.metrics.messageReceived(msg.address(), !msg.isSend(), messageLocal, handlers.size());
                }
                for (HandlerHolder holder : handlers) {
                    if (!messageLocal && holder.isLocalOnly()) continue;
                    holder.handler.receive(msg.copyBeforeReceive());
                }
            }
            return null;
        }
        if (this.metrics != null) {
            this.metrics.messageReceived(msg.address(), !msg.isSend(), messageLocal, 0);
        }
        return new ReplyException(ReplyFailure.NO_HANDLERS, "No handlers for address " + msg.address);
    }

    protected HandlerHolder nextHandler(ConcurrentCyclicSequence<HandlerHolder> handlers, boolean messageLocal) {
        return handlers.next();
    }

    protected void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Event Bus is not started");
        }
    }

    protected String generateReplyAddress() {
        return "__vertx.reply." + Long.toString(this.replySequence.incrementAndGet());
    }

    <T> ReplyHandler<T> createReplyHandler(MessageImpl message, boolean src, DeliveryOptions options) {
        long timeout = options.getSendTimeout();
        String replyAddress = this.generateReplyAddress();
        message.setReplyAddress(replyAddress);
        ReplyHandler handler = new ReplyHandler(this, this.vertx.getOrCreateContext(), replyAddress, message.address, src, timeout);
        handler.register();
        return handler;
    }

    public <T> OutboundDeliveryContext<T> newSendContext(MessageImpl message, DeliveryOptions options, ReplyHandler<T> handler, Promise<Void> writePromise) {
        return new OutboundDeliveryContext<T>(this.vertx.getOrCreateContext(), message, options, handler, writePromise);
    }

    public <T> void sendOrPubInternal(OutboundDeliveryContext<T> senderCtx) {
        this.checkStarted();
        senderCtx.bus = this;
        senderCtx.metrics = this.metrics;
        senderCtx.next();
    }

    public <T> void sendOrPubInternal(MessageImpl message, DeliveryOptions options, ReplyHandler<T> handler, Promise<Void> writePromise) {
        this.checkStarted();
        if (writePromise == null) {
            this.sendOrPubInternal(this.newSendContext(message, options, handler, null));
            return;
        }
        Promise<Void> promise = Promise.promise();
        this.sendOrPubInternal(this.newSendContext(message, options, handler, promise));
        Future<Void> future = promise.future();
        if (!message.send) {
            future = future.recover(throwable -> {
                if (throwable instanceof ReplyException) {
                    return Future.failedFuture(throwable);
                }
                return Future.succeededFuture();
            });
        }
        future.onComplete(writePromise);
    }

    private Future<Void> unregisterAll() {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (ConcurrentCyclicSequence handlers : this.handlerMap.values()) {
            for (HandlerHolder holder : handlers) {
                futures.add(holder.getHandler().unregister());
            }
        }
        return Future.join(futures).mapEmpty();
    }

    private void addInterceptor(AtomicReferenceFieldUpdater<EventBusImpl, Handler[]> updater, Handler interceptor) {
        Handler[] copy;
        Handler[] interceptors;
        do {
            interceptors = updater.get(this);
            copy = Arrays.copyOf(interceptors, interceptors.length + 1);
            copy[interceptors.length] = interceptor;
        } while (!updater.compareAndSet(this, interceptors, copy));
    }

    private void removeInterceptor(AtomicReferenceFieldUpdater<EventBusImpl, Handler[]> updater, Handler interceptor) {
        Handler[] copy;
        Handler[] interceptors;
        do {
            interceptors = updater.get(this);
            int idx = -1;
            for (int i = 0; i < interceptors.length; ++i) {
                if (!interceptors[i].equals(interceptor)) continue;
                idx = i;
                break;
            }
            if (idx == -1) {
                return;
            }
            copy = new Handler[interceptors.length - 1];
            System.arraycopy(interceptors, 0, copy, 0, idx);
            System.arraycopy(interceptors, idx + 1, copy, idx, copy.length - idx);
        } while (!updater.compareAndSet(this, interceptors, copy));
    }

    private boolean isLocalOnly(DeliveryOptions options) {
        if (this.vertx.isClustered()) {
            return options.isLocalOnly();
        }
        return true;
    }
}

